/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class DoubleFrame
extends RawFrame
implements Cloneable {
    public final double[][] origframe;

    public DoubleFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        super(bandCount, pixelWidth, bandNames);
        this.origframe = new double[bandCount.value][pixelWidth.value];
    }

    @Override
    public DoubleFrame copy() {
        DoubleFrame doubleFrame = new DoubleFrame(this.getRows(), this.getColumns(), this.getBandNames());
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], 0, doubleFrame.origframe[i], 0, this.columns.value);
        }
        return doubleFrame;
    }

    public final void copyFromBuffer(double[] dArray, RtInterleave rtInterleave, boolean bl) {
        int n = 0;
        switch (rtInterleave) {
            case BIL: {
                if (bl) {
                    for (int i = 0; i < this.rows.value; ++i) {
                        for (int j = 0; j < this.columns.value; ++j) {
                            this.origframe[i][this.columns.value - j - 1] = dArray[n++];
                        }
                    }
                } else {
                    for (int i = 0; i < this.rows.value; ++i) {
                        for (int j = 0; j < this.columns.value; ++j) {
                            this.origframe[i][j] = dArray[n++];
                        }
                    }
                }
                break;
            }
            case BIP: {
                if (bl) {
                    for (int i = 0; i < this.columns.value; ++i) {
                        for (int j = 0; j < this.rows.value; ++j) {
                            this.origframe[j][this.columns.value - i - 1] = dArray[n++];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns.value; ++i) {
                        for (int j = 0; j < this.rows.value; ++j) {
                            this.origframe[j][i] = dArray[n++];
                        }
                    }
                }
                break;
            }
            case BSQ: 
            case BSQ_COL: {
                break;
            }
        }
    }

    @Override
    public final void copyFrameIntoBlock(RtFrame rtFrame, int n, int[] nArray) {
        FloatMatrix floatMatrix = rtFrame.floatMatrix[n];
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < floatMatrix.columns; ++i) {
            int n3;
            int n4 = floatMatrix.rows * i;
            int n5 = i + n2;
            if (nArray != null) {
                for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                    floatMatrix.data[n4 + n3] = (float)this.origframe[nArray[n3]][n5];
                }
                continue;
            }
            for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                floatMatrix.data[n4 + n3] = (float)this.origframe[n3][n5];
            }
        }
    }

    @Override
    public final void copyFrameBlock(Frame frame, RtFrame rtFrame, int n) {
        FloatMatrix floatMatrix = rtFrame.getMatrix(n);
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], n2, ((DoubleFrame)frame).origframe[i], n2, floatMatrix.columns);
        }
    }

    public final void copyFromBufferBSQ(double[] dArray, int n, int n2) {
        for (int i = 0; i < this.columns.value; ++i) {
            this.origframe[n][i] = dArray[n2++];
        }
    }

    @Override
    public final float getFrameValue(int n, int n2) {
        return (float)this.origframe[n][n2];
    }

    @Override
    public final void setFrameValue(int n, int n2, float f) {
        this.origframe[n][n2] = f;
    }

    public final double getFrameValueNative(int n, int n2) {
        return this.origframe[n][n2];
    }

    @Override
    public DataSize getType() {
        return DataSize.DOUBLE_8;
    }
}

