/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.common.util.raw.AverageFloatMatrix;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.frontend.main.settings.measurement.ReferenceHelper;
import se.prediktera.breeze.hardware.camera.RemoteCamera;

public class DrReMatrix {
    private final RemoteCamera camera;
    private RawFrame reFrame = null;
    private float[][] reMatrixInversed = null;

    public DrReMatrix(RemoteCamera remoteCamera) {
        String string;
        this.camera = remoteCamera;
        if (remoteCamera.useReferencesWhenRecordingWithThisCamera() && (string = remoteCamera.getRemoteSettings().getCameraProperty("ReMatrix")).length() > 0) {
            byte[] byArray = Base64.getDecoder().decode(string);
            int n = remoteCamera.getBandCount().value * remoteCamera.getWidth().value;
            this.reFrame = DrReMatrix.createFrame(remoteCamera, byArray, DataSize.fromEvinceDataSize(byArray.length / n), remoteCamera.isFlipped());
            if (this.reFrame != null) {
                FloatMatrix floatMatrix = this.reFrame.toFloatMatrix();
                this.reMatrixInversed = floatMatrix.toArray2();
                for (int i = 0; i < this.reMatrixInversed.length; ++i) {
                    for (int j = 0; j < this.reMatrixInversed[i].length; ++j) {
                        float f = this.reMatrixInversed[i][j];
                        if (f == 0.0f) continue;
                        this.reMatrixInversed[i][j] = 1.0f / f;
                    }
                }
            }
        }
        if (this.reMatrixInversed == null) {
            this.reMatrixInversed = this.createWithValue(remoteCamera, 1.0f);
        }
    }

    private float[][] createWithValue(RemoteCamera remoteCamera, float f) {
        float[][] fArrayArray = new float[remoteCamera.getBandCount().value][];
        int n = remoteCamera.getWidth().value;
        for (int i = 0; i < fArrayArray.length; ++i) {
            fArrayArray[i] = new float[n];
            for (int j = 0; j < n; ++j) {
                fArrayArray[i][j] = f;
            }
        }
        return fArrayArray;
    }

    public Frame getFrame() {
        return this.reFrame;
    }

    public float[][] getReMatrixInversed() {
        return this.reMatrixInversed;
    }

    private static RawFrame createFrame(RemoteCamera remoteCamera, byte[] byArray, DataSize dataSize, boolean bl) {
        if (dataSize.equals((Object)DataSize.FLOAT_4) || dataSize.equals((Object)DataSize.DOUBLE_8)) {
            float[] fArray;
            Object object;
            if (dataSize.equals((Object)DataSize.DOUBLE_8)) {
                object = new double[byArray.length / 8];
                ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asDoubleBuffer().get((double[])object);
                fArray = new float[((double[])object).length];
                for (int i = 0; i < ((double[])object).length; ++i) {
                    fArray[i] = (float)object[i];
                }
            } else {
                fArray = new float[byArray.length / 4];
                ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().get(fArray);
            }
            object = (FloatFrame)Frame.createFrame(DataSize.FLOAT_4, remoteCamera.getBandCount(), remoteCamera.getWidth(), remoteCamera.getBandNames());
            ((FloatFrame)object).copyFromBuffer(fArray, remoteCamera.getInterleave(), bl);
            return object;
        }
        RawFrame rawFrame = Frame.createFrame(dataSize, remoteCamera.getBandCount(), remoteCamera.getWidth(), remoteCamera.getBandNames());
        if (dataSize.equals((Object)DataSize.SHORT_2)) {
            ((ShortFrame)rawFrame).copyFromBuffer(byArray, remoteCamera.getInterleave(), remoteCamera.getByteOrder(), bl, 0);
        } else {
            ((ByteFrame)rawFrame).copyFromBuffer(byArray, remoteCamera.getInterleave(), bl, 0);
        }
        return rawFrame;
    }

    public SpectralReference.DarkReference getDarkReference() {
        return ReferenceHelper.getDarkReference(this.camera);
    }

    public float[][] getDarkMatrix() {
        SpectralReference.DarkReference darkReference = this.getDarkReference();
        if (darkReference != null) {
            return new AverageFloatMatrix(darkReference.getMatrix()).toArray2();
        }
        return this.createWithValue(this.camera, 0.0f);
    }
}

