/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import java.util.ArrayList;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class FloatFrame
extends RawFrame
implements Cloneable {
    public final float[][] origframe;

    public FloatFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        super(bandCount, pixelWidth, bandNames);
        this.origframe = new float[bandCount.value][pixelWidth.value];
    }

    @Override
    public FloatFrame copy() {
        FloatFrame floatFrame = new FloatFrame(this.getRows(), this.getColumns(), this.getBandNames());
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], 0, floatFrame.origframe[i], 0, this.columns.value);
        }
        return floatFrame;
    }

    public final void copyFromBuffer(float[] fArray, RtInterleave rtInterleave, boolean bl) {
        int n = 0;
        switch (rtInterleave) {
            case BIL: {
                if (bl) {
                    for (int i = 0; i < this.rows.value; ++i) {
                        for (int j = 0; j < this.columns.value; ++j) {
                            this.origframe[i][this.columns.value - j - 1] = fArray[n++];
                        }
                    }
                } else {
                    for (int i = 0; i < this.rows.value; ++i) {
                        for (int j = 0; j < this.columns.value; ++j) {
                            this.origframe[i][j] = fArray[n++];
                        }
                    }
                }
                break;
            }
            case BIP: {
                if (bl) {
                    for (int i = 0; i < this.columns.value; ++i) {
                        for (int j = 0; j < this.rows.value; ++j) {
                            this.origframe[j][this.columns.value - i - 1] = fArray[n++];
                        }
                    }
                } else {
                    for (int i = 0; i < this.columns.value; ++i) {
                        for (int j = 0; j < this.rows.value; ++j) {
                            this.origframe[j][i] = fArray[n++];
                        }
                    }
                }
                break;
            }
            case BSQ: 
            case BSQ_COL: {
                break;
            }
        }
    }

    @Override
    public final void copyFrameIntoBlock(RtFrame rtFrame, int n, int[] nArray) {
        FloatMatrix floatMatrix = rtFrame.floatMatrix[n];
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < floatMatrix.columns; ++i) {
            int n3;
            int n4 = floatMatrix.rows * i;
            int n5 = i + n2;
            if (nArray != null) {
                for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                    floatMatrix.data[n4 + n3] = this.origframe[nArray[n3]][n5];
                }
                continue;
            }
            for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                floatMatrix.data[n4 + n3] = this.origframe[n3][n5];
            }
        }
    }

    @Override
    public final void copyFrameBlock(Frame frame, RtFrame rtFrame, int n) {
        FloatMatrix floatMatrix = rtFrame.getMatrix(n);
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], n2, ((FloatFrame)frame).origframe[i], n2, floatMatrix.columns);
        }
    }

    public final void copyFromBufferBSQ(float[] fArray, int n, int n2) {
        for (int i = 0; i < this.columns.value; ++i) {
            this.setFrameValue(n, i, fArray[n2++]);
        }
    }

    @Override
    public final float getFrameValue(int n, int n2) {
        return this.origframe[n][n2];
    }

    @Override
    public final void setFrameValue(int n, int n2, float f) {
        this.origframe[n][n2] = f;
    }

    @Override
    public DataSize getType() {
        return DataSize.FLOAT_4;
    }

    public static float[] convertDoubleToFloatArray(double[] dArray, float[] fArray) {
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    public static List<RawFrame> getFrames(FloatMatrix[] floatMatrixArray) {
        ArrayList<RawFrame> arrayList = new ArrayList<RawFrame>();
        for (FloatMatrix floatMatrix : floatMatrixArray) {
            BandCount bandCount = new BandCount(floatMatrix.rows);
            FloatFrame floatFrame = new FloatFrame(bandCount, new PixelWidth(floatMatrix.columns), bandCount.indexBands());
            for (int i = 0; i < floatMatrix.columns; ++i) {
                for (int j = 0; j < floatMatrix.rows; ++j) {
                    floatFrame.origframe[j][i] = floatMatrix.get(j, i);
                }
            }
            arrayList.add(floatFrame);
        }
        return arrayList;
    }
}

