/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import java.io.File;
import java.util.Arrays;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.DoubleFrame;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.raw.RawFileWriter;
import se.prediktera.breeze.common.util.raw.RawHeader;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.FrameCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RgbBands;

public abstract class Frame
implements Cloneable {
    public BandCount rows;
    public PixelWidth columns;
    public BandNames bandNames;
    public boolean rgbFrame = false;

    public Frame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        this.rows = bandCount;
        this.columns = pixelWidth;
        this.bandNames = bandNames;
    }

    public abstract float getFrameValue(int var1, int var2);

    public abstract void setFrameValue(int var1, int var2, float var3);

    public abstract Frame copy();

    public abstract DataSize getType();

    public final void copyTo(FloatMatrix floatMatrix) {
        for (int i = 0; i < this.rows.value; ++i) {
            for (int j = 0; j < this.columns.value; ++j) {
                floatMatrix.put(i, j, this.getFrameValue(i, j));
            }
        }
    }

    public void copyFrameIntoBlock(RtFrame rtFrame, int n, int[] nArray) {
        FloatMatrix floatMatrix = rtFrame.floatMatrix[n];
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < floatMatrix.columns; ++i) {
            int n3;
            int n4 = floatMatrix.rows * i;
            int n5 = i + n2;
            if (nArray != null) {
                for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                    floatMatrix.data[n4 + n3] = this.getFrameValue(nArray[n3], n5);
                }
                continue;
            }
            for (n3 = 0; n3 < floatMatrix.rows; ++n3) {
                floatMatrix.data[n4 + n3] = this.getFrameValue(n3, n5);
            }
        }
    }

    public void copyFrameBlock(Frame frame, RtFrame rtFrame, int n) {
        throw new RuntimeException("Operation not support for this frame");
    }

    public PixelWidth getColumns() {
        return this.columns;
    }

    public BandCount getRows() {
        return this.rows;
    }

    public BandNames getBandNames() {
        return this.bandNames;
    }

    public RawFrame recudeFrame(FrameListFromRaw.Reduce reduce) {
        RawFrame rawFrame = this.createFrame(this.rows, new PixelWidth(this.columns.value / reduce.x), this.bandNames);
        int n = 0;
        int n2 = 0;
        while (n < rawFrame.columns.value) {
            for (int i = 0; i < this.rows.value; ++i) {
                rawFrame.setFrameValue(i, n, this.getFrameValue(i, n2));
            }
            ++n;
            n2 += reduce.x;
        }
        return rawFrame;
    }

    public Frame crop(int n, int n2) {
        int n3 = n2 - n;
        if (this.columns.value == n3) {
            return this;
        }
        RawFrame rawFrame = this.createFrame(this.rows, new PixelWidth(n3), this.bandNames);
        int n4 = n;
        int n5 = 0;
        while (n4 < n2) {
            for (int i = 0; i < this.rows.value; ++i) {
                rawFrame.setFrameValue(i, n5, this.getFrameValue(i, n4));
            }
            ++n4;
            ++n5;
        }
        return rawFrame;
    }

    public float getReferenceValue(int n, int n2) {
        return this.getFrameValue(n, n2);
    }

    protected RawFrame createFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        if (this instanceof ByteFrame) {
            return new ByteFrame(this.rows, pixelWidth, bandNames);
        }
        if (this instanceof ShortFrame) {
            return new ShortFrame(this.rows, pixelWidth, bandNames);
        }
        if (this instanceof FloatFrame) {
            return new FloatFrame(this.rows, pixelWidth, bandNames);
        }
        if (this instanceof DoubleFrame) {
            return new DoubleFrame(this.rows, pixelWidth, bandNames);
        }
        throw new RuntimeException("Create frame not supported for this frame type");
    }

    public void save(File file) {
        RawFileWriter.writeFramesAndHeader(file, Arrays.asList(this), new RawHeader(null, new FrameCount(1), this.getRows(), this.getColumns(), this.getType(), RgbBands.fromBandCount(this.getRows()), this.getBandNames()), "", null, null);
    }

    public long dataSize() {
        return this.getRows().value * this.getColumns().value * this.getType().size;
    }

    public static RawFrame createFrame(DataSize dataSize, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        return switch (dataSize) {
            default -> throw new MatchException(null, null);
            case DataSize.BYTE_1 -> new ByteFrame(bandCount, pixelWidth, bandNames);
            case DataSize.SHORT_2 -> new ShortFrame(bandCount, pixelWidth, bandNames);
            case DataSize.FLOAT_4 -> new FloatFrame(bandCount, pixelWidth, bandNames);
            case DataSize.DOUBLE_8 -> new DoubleFrame(bandCount, pixelWidth, bandNames);
        };
    }
}

