/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import se.prediktera.breeze.common.frame.ByteFrame;
import se.prediktera.breeze.common.frame.FloatFrame;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.frame.ShortFrame;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;

public abstract class FrameType {
    private final DataSize dataSize;
    protected final PixelWidth pixelWidth;
    protected final BandCount bandCount;
    protected final BandNames bandNames;
    protected final RtInterleave interleave;
    protected final RtByteOrder byteOrder;
    protected boolean flip = false;
    protected final int frameDataSize;

    public FrameType(DataSize dataSize, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, RtInterleave rtInterleave, RtByteOrder rtByteOrder, boolean bl) {
        this.dataSize = dataSize;
        this.bandCount = bandCount;
        this.pixelWidth = pixelWidth;
        this.bandNames = bandNames;
        this.interleave = rtInterleave;
        this.byteOrder = rtByteOrder;
        this.flip = bl;
        int n = bandCount.value * pixelWidth.value;
        this.frameDataSize = n * dataSize.size;
    }

    public abstract RawFrame read(RawFrame var1, byte[] var2, int var3);

    public RawFrame create(byte[] byArray) {
        return this.read(Frame.createFrame(this.dataSize, this.bandCount, this.pixelWidth, this.bandNames), byArray, 0);
    }

    public int getFrameSize() {
        return this.frameDataSize;
    }

    public BandCount getBandCount() {
        return this.bandCount;
    }

    public static FrameType createFrameHandle(DataSize dataSize, BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, RtInterleave rtInterleave, RtByteOrder rtByteOrder, boolean bl) {
        if (dataSize == DataSize.BYTE_1) {
            return new HandleFrameByte(bandCount, pixelWidth, bandNames, rtInterleave, rtByteOrder, bl);
        }
        if (dataSize == DataSize.SHORT_2) {
            return new HandleFrameShort(bandCount, pixelWidth, bandNames, rtInterleave, rtByteOrder, bl);
        }
        if (dataSize == DataSize.FLOAT_4 || dataSize == DataSize.DOUBLE_8) {
            return new HandleFrameFloat(bandCount, pixelWidth, bandNames, rtInterleave, rtByteOrder, bl);
        }
        throw new RuntimeException("Datasize not supported");
    }

    private static class HandleFrameByte
    extends FrameType {
        public HandleFrameByte(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, RtInterleave rtInterleave, RtByteOrder rtByteOrder, boolean bl) {
            super(DataSize.BYTE_1, bandCount, pixelWidth, bandNames, rtInterleave, rtByteOrder, bl);
        }

        @Override
        public RawFrame read(RawFrame rawFrame, byte[] byArray, int n) {
            if (rawFrame == null) {
                rawFrame = new ByteFrame(this.bandCount, this.pixelWidth, this.bandNames);
            }
            ((ByteFrame)rawFrame).copyFromBuffer(byArray, this.interleave, this.flip, n);
            return rawFrame;
        }
    }

    private static class HandleFrameShort
    extends FrameType {
        public HandleFrameShort(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, RtInterleave rtInterleave, RtByteOrder rtByteOrder, boolean bl) {
            super(DataSize.SHORT_2, bandCount, pixelWidth, bandNames, rtInterleave, rtByteOrder, bl);
        }

        @Override
        public RawFrame read(RawFrame rawFrame, byte[] byArray, int n) {
            if (rawFrame == null) {
                rawFrame = new ShortFrame(this.bandCount, this.pixelWidth, this.bandNames);
            }
            ((ShortFrame)rawFrame).copyFromBuffer(byArray, this.interleave, this.byteOrder, this.flip, n);
            return rawFrame;
        }
    }

    private static class HandleFrameFloat
    extends FrameType {
        private final float[] farray;

        public HandleFrameFloat(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames, RtInterleave rtInterleave, RtByteOrder rtByteOrder, boolean bl) {
            super(DataSize.FLOAT_4, bandCount, pixelWidth, bandNames, rtInterleave, rtByteOrder, bl);
            this.farray = new float[bandCount.value * pixelWidth.value];
        }

        @Override
        public RawFrame read(RawFrame rawFrame, byte[] byArray, int n) {
            ByteBuffer.wrap(byArray, n, this.frameDataSize).order(ByteOrder.LITTLE_ENDIAN).asFloatBuffer().get(this.farray);
            if (rawFrame == null) {
                rawFrame = new FloatFrame(this.bandCount, this.pixelWidth, this.bandNames);
            }
            ((FloatFrame)rawFrame).copyFromBuffer(this.farray, this.interleave, this.flip);
            return rawFrame;
        }
    }
}

