/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.FrameType;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.mat.FloatMatrixArrayFromFrames;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;

public abstract class RawFrame
extends Frame {
    public RawFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        super(bandCount, pixelWidth, bandNames);
    }

    public static List<Frame> getFramesFromBase64(String string) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        if (string.length() > 0) {
            new FramesBase64Parser(string, arrayList);
        }
        return arrayList;
    }

    @Override
    public abstract RawFrame copy();

    public FloatMatrix toFloatMatrix() {
        return new FloatMatrixArrayFromFrames(Arrays.asList(this)).array()[0];
    }

    private static class FramesBase64Parser {
        private int pos = 0;
        private final String property;

        public FramesBase64Parser(String string, List<Frame> list) {
            this.property = string;
            DataSize dataSize = DataSize.fromEvinceDataSize(this.nextValueInt());
            int n = this.nextValueInt();
            int n2 = this.nextValueInt();
            BandNames bandNames = BandNames.fromSemiColonSeparatedWavelengthList(this.nextValue());
            FrameType frameType = FrameType.createFrameHandle(dataSize, new BandCount(n), new PixelWidth(n2), bandNames, RtInterleave.BIL, RtByteOrder.LittleEndian, false);
            int n3 = this.nextValueInt();
            int n4 = string.length() - this.pos;
            int n5 = n4 / n3;
            for (int i = 0; i < n3; ++i) {
                byte[] byArray = Base64.getDecoder().decode(this.nextValue(n5));
                list.add(frameType.create(byArray));
            }
        }

        public String nextValue(int n) {
            String string = this.property.substring(this.pos, this.pos + n);
            this.pos += n;
            return string;
        }

        public String nextValue() {
            int n = this.property.indexOf(":", this.pos);
            String string = this.property.substring(this.pos, n);
            this.pos = n + 1;
            return string;
        }

        public int nextValueInt() {
            return RtDataFormat.toNumberInt(this.nextValue());
        }
    }
}

