/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.frame.RawFrame;
import se.prediktera.breeze.common.realtime.frame.RtFrame;
import se.prediktera.breeze.common.util.raw.FrameListFromRaw;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.common.util.type.DataSize;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtByteOrder;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.common.util.type.RtThreader;

public class ShortFrame
extends RawFrame
implements Cloneable {
    public final short[][] origframe;

    public ShortFrame(BandCount bandCount, PixelWidth pixelWidth, BandNames bandNames) {
        super(bandCount, pixelWidth, bandNames);
        this.origframe = new short[bandCount.value][pixelWidth.value];
    }

    @Override
    public ShortFrame copy() {
        ShortFrame shortFrame = new ShortFrame(this.getRows(), this.getColumns(), this.getBandNames());
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], 0, shortFrame.origframe[i], 0, this.columns.value);
        }
        return shortFrame;
    }

    public final void copyFromBuffer(final byte[] byArray, RtInterleave rtInterleave, RtByteOrder rtByteOrder, boolean bl, final int n) {
        if (rtByteOrder == RtByteOrder.LittleEndian) {
            switch (rtInterleave) {
                case BIL: {
                    if (bl) {
                        RtThreader rtThreader = new RtThreader(this){
                            final /* synthetic */ ShortFrame this$0;
                            {
                                this.this$0 = shortFrame;
                            }

                            @Override
                            protected void doOp(boolean bl, int n5, int n2) {
                                for (int i = n5; i < n2; ++i) {
                                    int n3 = i * this.this$0.columns.value;
                                    short[] sArray = this.this$0.origframe[i];
                                    for (int j = 0; j < this.this$0.columns.value; ++j) {
                                        int n4 = 2 * (n3 + j) + n;
                                        try {
                                            sArray[this.this$0.columns.value - j - 1] = (short)(byArray[n4 + 1] << 8 | 0xFF & byArray[n4]);
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            throw new RuntimeException(exception);
                                        }
                                    }
                                }
                            }
                        };
                        rtThreader.execute(this.rows.value);
                        break;
                    }
                    final int n2 = this.columns.value * 2;
                    RtThreader rtThreader = new RtThreader(this){
                        final /* synthetic */ ShortFrame this$0;
                        {
                            this.this$0 = shortFrame;
                        }

                        @Override
                        protected void doOp(boolean bl, int n, int n22) {
                            for (int i = n; i < n22; ++i) {
                                int n3 = i * n2;
                                ByteBuffer.wrap(byArray, n3, n2).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(this.this$0.origframe[i]);
                            }
                        }
                    };
                    rtThreader.execute(this.rows.value);
                    break;
                }
                case BIP: {
                    if (bl) {
                        RtThreader rtThreader = new RtThreader(this){
                            final /* synthetic */ ShortFrame this$0;
                            {
                                this.this$0 = shortFrame;
                            }

                            @Override
                            protected void doOp(boolean bl, int n5, int n2) {
                                for (int i = n5; i < n2; ++i) {
                                    int n3 = i * this.this$0.rows.value;
                                    for (int j = 0; j < this.this$0.rows.value; ++j) {
                                        int n4 = 2 * (n3 + j) + n;
                                        this.this$0.origframe[j][this.this$0.columns.value - i - 1] = (short)(byArray[n4 + 1] << 8 | 0xFF & byArray[n4]);
                                    }
                                }
                            }
                        };
                        rtThreader.execute(this.columns.value);
                        break;
                    }
                    RtThreader rtThreader = new RtThreader(this){
                        final /* synthetic */ ShortFrame this$0;
                        {
                            this.this$0 = shortFrame;
                        }

                        @Override
                        protected void doOp(boolean bl, int n5, int n2) {
                            for (int i = n5; i < n2; ++i) {
                                int n3 = i * this.this$0.rows.value;
                                for (int j = 0; j < this.this$0.rows.value; ++j) {
                                    int n4 = 2 * (n3 + j) + n;
                                    this.this$0.origframe[j][i] = (short)(byArray[n4 + 1] << 8 | 0xFF & byArray[n4]);
                                }
                            }
                        }
                    };
                    rtThreader.execute(this.columns.value);
                    break;
                }
                case BSQ: 
                case BSQ_COL: {
                    break;
                }
            }
        } else {
            switch (rtInterleave) {
                case BIL: {
                    if (bl) {
                        RtThreader rtThreader = new RtThreader(this){
                            final /* synthetic */ ShortFrame this$0;
                            {
                                this.this$0 = shortFrame;
                            }

                            @Override
                            protected void doOp(boolean bl, int n5, int n2) {
                                for (int i = n5; i < n2; ++i) {
                                    int n3 = i * this.this$0.columns.value;
                                    for (int j = 0; j < this.this$0.columns.value; ++j) {
                                        int n4 = 2 * (n3 + j) + n;
                                        try {
                                            this.this$0.origframe[i][this.this$0.columns.value - j - 1] = (short)(byArray[n4] << 8 | 0xFF & byArray[n4 + 1]);
                                            continue;
                                        }
                                        catch (Exception exception) {
                                            throw new RuntimeException(exception);
                                        }
                                    }
                                }
                            }
                        };
                        rtThreader.execute(this.rows.value);
                        break;
                    }
                    RtThreader rtThreader = new RtThreader(this){
                        final /* synthetic */ ShortFrame this$0;
                        {
                            this.this$0 = shortFrame;
                        }

                        @Override
                        protected void doOp(boolean bl, int n5, int n2) {
                            for (int i = n5; i < n2; ++i) {
                                int n3 = i * this.this$0.columns.value;
                                for (int j = 0; j < this.this$0.columns.value; ++j) {
                                    int n4 = 2 * (n3 + j) + n;
                                    this.this$0.origframe[i][j] = (short)(byArray[n4] << 8 | 0xFF & byArray[n4 + 1]);
                                }
                            }
                        }
                    };
                    rtThreader.execute(this.rows.value);
                    break;
                }
                case BIP: {
                    if (bl) {
                        RtThreader rtThreader = new RtThreader(this){
                            final /* synthetic */ ShortFrame this$0;
                            {
                                this.this$0 = shortFrame;
                            }

                            @Override
                            protected void doOp(boolean bl, int n5, int n2) {
                                for (int i = n5; i < n2; ++i) {
                                    int n3 = i * this.this$0.rows.value;
                                    for (int j = 0; j < this.this$0.rows.value; ++j) {
                                        int n4 = 2 * (n3 + j) + n;
                                        this.this$0.origframe[j][this.this$0.columns.value - i - 1] = (short)(byArray[n4] << 8 | 0xFF & byArray[n4 + 1]);
                                    }
                                }
                            }
                        };
                        rtThreader.execute(this.columns.value);
                        break;
                    }
                    RtThreader rtThreader = new RtThreader(this){
                        final /* synthetic */ ShortFrame this$0;
                        {
                            this.this$0 = shortFrame;
                        }

                        @Override
                        protected void doOp(boolean bl, int n5, int n2) {
                            for (int i = n5; i < n2; ++i) {
                                int n3 = i * this.this$0.rows.value;
                                for (int j = 0; j < this.this$0.rows.value; ++j) {
                                    int n4 = 2 * (n3 + j) + n;
                                    this.this$0.origframe[j][i] = (short)(byArray[n4] << 8 | 0xFF & byArray[n4 + 1]);
                                }
                            }
                        }
                    };
                    rtThreader.execute(this.columns.value);
                    break;
                }
                case BSQ: 
                case BSQ_COL: {
                    break;
                }
            }
        }
    }

    @Override
    public final void copyFrameIntoBlock(RtFrame rtFrame, int n, int[] nArray) {
        FloatMatrix floatMatrix = rtFrame.floatMatrix[n];
        int n2 = rtFrame.blockOffset[n];
        int n3 = floatMatrix.columns;
        int n4 = floatMatrix.rows;
        if (nArray != null) {
            int n5 = 0;
            int n6 = 0;
            while (n5 < n3) {
                int n7 = n5 + n2;
                for (int i = 0; i < n4; ++i) {
                    floatMatrix.data[n6 + i] = this.origframe[nArray[i]][n7] & 0xFFFF;
                }
                ++n5;
                n6 += n4;
            }
        } else {
            int n8 = 0;
            int n9 = 0;
            while (n8 < n3) {
                int n10 = n8 + n2;
                for (int i = 0; i < n4; ++i) {
                    floatMatrix.data[n9 + i] = this.origframe[i][n10] & 0xFFFF;
                }
                ++n8;
                n9 += n4;
            }
        }
    }

    @Override
    public final void copyFrameBlock(Frame frame, RtFrame rtFrame, int n) {
        FloatMatrix floatMatrix = rtFrame.getMatrix(n);
        int n2 = rtFrame.blockOffset[n];
        for (int i = 0; i < this.rows.value; ++i) {
            System.arraycopy(this.origframe[i], n2, ((ShortFrame)frame).origframe[i], n2, floatMatrix.columns);
        }
    }

    public final int copyFromBufferBSQ(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < this.columns.value) {
            this.origframe[n][n3] = (short)(byArray[n2 + 1] << 8 | 0xFF & byArray[n2]);
            ++n3;
            n2 += 2;
        }
        return n2;
    }

    public final short getFrameValueNative(int n, int n2) {
        return this.origframe[n][n2];
    }

    @Override
    public RawFrame recudeFrame(FrameListFromRaw.Reduce reduce) {
        ShortFrame shortFrame = (ShortFrame)this.createFrame(this.rows, new PixelWidth(this.columns.value / reduce.x), this.bandNames);
        short[][] sArray = shortFrame.origframe;
        int n = shortFrame.columns.value;
        for (int i = 0; i < this.rows.value; ++i) {
            short[] sArray2 = sArray[i];
            short[] sArray3 = this.origframe[i];
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                sArray2[n2] = sArray3[n3];
                ++n2;
                n3 += reduce.x;
            }
        }
        return shortFrame;
    }

    @Override
    public final float getFrameValue(int n, int n2) {
        return this.origframe[n][n2] & 0xFFFF;
    }

    @Override
    public final void setFrameValue(int n, int n2, float f) {
        this.origframe[n][n2] = (short)f;
    }

    @Override
    public DataSize getType() {
        return DataSize.SHORT_2;
    }
}

