/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame.matrix;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtInterleave;

public class ByteFrameMatrix
extends FloatMatrix {
    public ByteFrameMatrix(BandCount bandCount, PixelWidth pixelWidth, byte[] byArray, RtInterleave rtInterleave, boolean bl) {
        super(bandCount.value, pixelWidth.value);
        int n = 0;
        switch (rtInterleave) {
            case BIL: {
                if (bl) {
                    for (int i = 0; i < bandCount.value; ++i) {
                        for (int j = 0; j < pixelWidth.value; ++j) {
                            this.put(i, pixelWidth.value - j - 1, byArray[n++]);
                        }
                    }
                } else {
                    for (int i = 0; i < bandCount.value; ++i) {
                        for (int j = 0; j < pixelWidth.value; ++j) {
                            this.put(i, j, byArray[n++]);
                        }
                    }
                }
                break;
            }
            case BIP: {
                if (bl) {
                    for (int i = 0; i < pixelWidth.value; ++i) {
                        for (int j = 0; j < bandCount.value; ++j) {
                            this.put(j, pixelWidth.value - i - 1, byArray[n++]);
                        }
                    }
                } else {
                    for (int i = 0; i < pixelWidth.value; ++i) {
                        for (int j = 0; j < bandCount.value; ++j) {
                            this.put(j, i, byArray[n++]);
                        }
                    }
                }
                break;
            }
            case BSQ: 
            case BSQ_COL: {
                break;
            }
        }
    }
}

