/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.frame.matrix;

import org.jblas.FloatMatrix;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.type.PixelWidth;
import se.prediktera.breeze.common.util.type.RtInterleave;
import se.prediktera.breeze.common.util.type.RtThreader;

public class FloatFrameMatrix
extends FloatMatrix {
    public FloatFrameMatrix(BandCount bandCount, PixelWidth pixelWidth) {
        super(bandCount.value, pixelWidth.value);
    }

    public FloatFrameMatrix(BandCount bandCount, final PixelWidth pixelWidth, final float[] fArray, RtInterleave rtInterleave, boolean bl) {
        super(bandCount.value, pixelWidth.value);
        int n = 0;
        switch (rtInterleave) {
            case BIL: {
                if (bl) {
                    for (int i = 0; i < bandCount.value; ++i) {
                        for (int j = 0; j < pixelWidth.value; ++j) {
                            this.put(i, pixelWidth.value - j - 1, fArray[n++]);
                        }
                    }
                    break;
                }
                RtThreader rtThreader = new RtThreader(this){
                    final /* synthetic */ FloatFrameMatrix this$0;
                    {
                        this.this$0 = floatFrameMatrix;
                    }

                    @Override
                    protected void doOp(boolean bl, int n, int n2) {
                        for (int i = n; i < n2; ++i) {
                            int n3 = i * pixelWidth.value;
                            for (int j = 0; j < pixelWidth.value; ++j) {
                                this.this$0.put(i, j, fArray[n3 + j]);
                            }
                        }
                    }
                };
                rtThreader.execute(bandCount.value);
                break;
            }
            case BIP: {
                if (bl) {
                    for (int i = 0; i < pixelWidth.value; ++i) {
                        for (int j = 0; j < bandCount.value; ++j) {
                            this.put(j, pixelWidth.value - i - 1, fArray[n++]);
                        }
                    }
                } else {
                    for (int i = 0; i < pixelWidth.value; ++i) {
                        for (int j = 0; j < bandCount.value; ++j) {
                            this.put(j, i, fArray[n++]);
                        }
                    }
                }
                break;
            }
            case BSQ: 
            case BSQ_COL: {
                break;
            }
        }
    }
}

