/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.model;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SVD;
import se.prediktera.breeze.common.frame.Frame;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;

public class BreezePca {
    private final DenseMatrix t;
    private final DenseMatrix p;
    private DenseVector q2xCum;

    public BreezePca(DenseMatrix denseMatrix) {
        try {
            int n = denseMatrix.numRows();
            int n2 = denseMatrix.numColumns();
            if (n < n2) {
                System.out.println("X*XT");
                DenseMatrix denseMatrix2 = new DenseMatrix(n, n);
                denseMatrix.transBmult((Matrix)denseMatrix, (Matrix)denseMatrix2);
                SVD sVD = SVD.factorize((Matrix)denseMatrix2);
                this.p = new DenseMatrix(n, n2);
                sVD.getVt().mult((Matrix)denseMatrix, (Matrix)this.p);
                double[] dArray = sVD.getS();
                double[] dArray2 = this.p.getData();
                for (int i = 0; i < n; ++i) {
                    double d = 1.0 / Math.sqrt(dArray[i]);
                    for (int j = 0; j < n2; ++j) {
                        int n3 = j * n + i;
                        dArray2[n3] = dArray2[n3] * d;
                    }
                }
            } else {
                DenseMatrix denseMatrix3 = new DenseMatrix(n2, n2);
                denseMatrix.transAmult((Matrix)denseMatrix, (Matrix)denseMatrix3);
                SVD sVD = SVD.factorize((Matrix)denseMatrix3);
                this.p = sVD.getVt();
            }
            this.t = new DenseMatrix(this.p.numRows(), n);
            this.p.transBmult((Matrix)denseMatrix, (Matrix)this.t);
        }
        catch (NotConvergedException notConvergedException) {
            throw new RuntimeException(notConvergedException);
        }
    }

    public int getComponents() {
        return this.t.numColumns();
    }

    public DenseVector getT(int n) {
        int n2 = this.t.numColumns();
        DenseVector denseVector = new DenseVector(n2);
        for (int i = 0; i < n2; ++i) {
            denseVector.set(i, this.t.get(n, i));
        }
        return denseVector;
    }

    public DenseMatrix getT(int n, int n2) {
        int n3 = this.getComponents();
        DenseMatrix denseMatrix = new DenseMatrix(n3, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                denseMatrix.set(j, i, this.t.get(n + i, j));
            }
        }
        return denseMatrix;
    }

    public DenseMatrix getT() {
        return this.t;
    }

    public double getValueT(int n, int n2) {
        return this.t.get(n, n2);
    }

    public DenseVector getP(int n) {
        int n2 = this.p.numColumns();
        DenseVector denseVector = new DenseVector(n2);
        for (int i = 0; i < n2; ++i) {
            denseVector.set(i, this.p.get(n, i));
        }
        return denseVector;
    }

    public DenseMatrix getP(int n, int n2) {
        int n3 = this.p.numColumns();
        DenseMatrix denseMatrix = new DenseMatrix(n3, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                denseMatrix.set(j, i, this.p.get(n + i, j));
            }
        }
        return denseMatrix;
    }

    public double getValueP(int n, int n2) {
        return this.p.get(n, n2);
    }

    public DenseMatrix getP() {
        return this.p;
    }

    public void setQ2xCum(DenseVector denseVector) {
        this.q2xCum = denseVector;
    }

    public double getQ2xCum(int n) {
        return this.q2xCum.get(n);
    }

    public double getQ2x(int n) {
        if (n == 0) {
            return this.getQ2xCum(n);
        }
        return this.getQ2xCum(n) - this.getQ2xCum(n - 1);
    }

    public static DenseMatrix createAndCenterXmatrix(RtFrameStackList.RealtimeFrameList realtimeFrameList) {
        DenseMatrix denseMatrix = new DenseMatrix(realtimeFrameList.size() * realtimeFrameList.getWidth().value, realtimeFrameList.getBandCount().value);
        int n = 0;
        for (Frame frame : realtimeFrameList) {
            int n2 = 0;
            while (n2 < frame.getColumns().value) {
                for (int i = 0; i < frame.getRows().value; ++i) {
                    float f = frame.getFrameValue(i, n2);
                    denseMatrix.set(n, i, (double)f);
                }
                ++n2;
                ++n;
            }
        }
        BreezePca.centerMatrix(denseMatrix);
        return denseMatrix;
    }

    public static void centerMatrix(DenseMatrix denseMatrix) {
        int n;
        int n2;
        double[] dArray = new double[denseMatrix.numColumns()];
        for (n2 = 0; n2 < denseMatrix.numRows(); ++n2) {
            for (n = 0; n < denseMatrix.numColumns(); ++n) {
                int n3 = n;
                dArray[n3] = dArray[n3] + denseMatrix.get(n2, n);
            }
        }
        n2 = 0;
        while (n2 < dArray.length) {
            int n4 = n2++;
            dArray[n4] = dArray[n4] / (double)denseMatrix.numRows();
        }
        for (n2 = 0; n2 < denseMatrix.numRows(); ++n2) {
            for (n = 0; n < denseMatrix.numColumns(); ++n) {
                denseMatrix.set(n2, n, denseMatrix.get(n2, n) - dArray[n]);
            }
        }
    }

    public static DenseMatrix getComponents(DenseMatrix denseMatrix, int n) {
        DenseMatrix denseMatrix2 = new DenseMatrix(denseMatrix.numColumns(), n);
        for (int i = 0; i < denseMatrix2.numRows(); ++i) {
            for (int j = 0; j < denseMatrix2.numColumns(); ++j) {
                denseMatrix2.set(i, j, denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    public static void saveCsv(DenseMatrix denseMatrix, File file) {
        try (PrintWriter printWriter = new PrintWriter(file, StandardCharsets.ISO_8859_1);){
            for (int i = 0; i < denseMatrix.numRows(); ++i) {
                for (int j = 0; j < denseMatrix.numColumns(); ++j) {
                    if (j > 0) {
                        printWriter.print(";");
                    }
                    printWriter.print(denseMatrix.get(i, j));
                }
                printWriter.println();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

