/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime;

import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.measure.SpectralReference;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.hardware.Camera;

public class RtFramesAndRefs {
    private final RtFrameStackList frameStackList;
    private final SpectralReference.WhiteReference whiteReference;
    private final SpectralReference.DarkReference darkReference;
    private final Measurement measurement;
    private Camera camera;

    public RtFramesAndRefs(RtFrameStackList rtFrameStackList, SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference) {
        this(rtFrameStackList, whiteReference, darkReference, null);
    }

    public RtFramesAndRefs(RtFrameStackList rtFrameStackList, SpectralReference.WhiteReference whiteReference, SpectralReference.DarkReference darkReference, Measurement measurement) {
        this.frameStackList = rtFrameStackList;
        this.whiteReference = whiteReference;
        this.darkReference = darkReference;
        this.measurement = measurement;
    }

    public RtFramesAndRefs(RtFrameStackList rtFrameStackList) {
        this(rtFrameStackList, null, null, null);
    }

    public RtFramesAndRefs(RtFrameStackList rtFrameStackList, Camera camera) {
        this(rtFrameStackList, null, null);
        this.camera = camera;
    }

    public RtFrameStackList frames() {
        return this.frameStackList;
    }

    public boolean hasReferences() {
        return this.whiteReference != null && this.darkReference != null;
    }

    public SpectralReference.WhiteReference whiteReference() {
        return this.whiteReference;
    }

    public SpectralReference.DarkReference darkReference() {
        return this.darkReference;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public void releaseFrames() {
        this.frameStackList.releaseFrameStacks();
    }

    public Camera getCamera() {
        return this.camera;
    }
}

