/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jblas.FloatMatrix;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.type.BandCount;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class RtModelParameters {
    private int variableCount;
    private int[] variableIndex;
    private String[] variableNames;
    private final List<RtModel> models = new ArrayList<RtModel>();

    public RtModelParameters() {
    }

    public RtModelParameters(Node node) {
        Object object;
        String string;
        String string2 = XmlParserHelper.getAttribute(node, "variables");
        if (string2 != null) {
            this.variableCount = RtDataFormat.toNumberInt(string2);
        }
        if ((string = XmlParserHelper.getAttribute(node, "variableIndex")) != null) {
            object = string.split(",");
            this.variableIndex = new int[((String[])object).length];
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.variableIndex[i] = RtDataFormat.toNumberInt(object[i]);
            }
        }
        if ((object = XmlParserHelper.getAttribute(node, "variableNames")) != null) {
            this.variableNames = string.split(",");
        }
        for (Node node2 : XmlParserHelper.getNodeList(node, "model")) {
            this.models.add(new RtModel(node2));
        }
    }

    public void addModel(RtModel rtModel) {
        this.models.add(rtModel);
    }

    public RtModel getModel() {
        return this.models.get(0);
    }

    public List<RtModel> getModels() {
        return this.models;
    }

    public void setVariableCount(int n) {
        this.variableCount = n;
    }

    public void setVariableIndex(int[] nArray) {
        this.variableIndex = nArray;
    }

    public int[] getVariableIndex() {
        return this.variableIndex;
    }

    public void setVariableNames(String[] stringArray) {
        this.variableNames = stringArray;
    }

    public void save(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "models");
        if (this.variableIndex != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.variableIndex.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.variableIndex[i]);
            }
            element2.setAttribute("variableIndex", stringBuilder.toString());
        }
        if (this.variableNames != null) {
            element2.setAttribute("variableNames", String.join((CharSequence)",", this.variableNames));
        }
        element2.setAttribute("variables", String.valueOf(this.variableCount));
        for (RtModel rtModel : this.models) {
            rtModel.save(element2);
        }
    }

    public void assertCompatible(BasicAnalyse basicAnalyse, BandCount bandCount) {
        if (bandCount != null && this.variableCount > 0 && this.variableCount != bandCount.value) {
            throw new RuntimeException(String.format("Number of bands (%d) is not compatible to number of variables (%d) in model (%s)", bandCount.value, this.variableCount, basicAnalyse.getName()));
        }
    }

    public static class RtModel {
        private final String name;
        private final RtModuleSetupList forward = new RtModuleSetupList();
        private final RtModuleSetupList modules = new RtModuleSetupList();
        private final RtModuleSetupList reverse = new RtModuleSetupList();
        private final List<RtModel> models = new ArrayList<RtModel>();

        public RtModel(String string) {
            this.name = string;
        }

        public RtModel(Node node) {
            this.name = XmlParserHelper.getAttribute(node, "name");
            for (Node node2 : XmlParserHelper.getNodeList(node, "module")) {
                String string = XmlParserHelper.getAttribute(node2, "type");
                if (string.equals("forward")) {
                    this.forward.add(new RtModuleSetup(node2));
                    continue;
                }
                if (string.equals("model")) {
                    this.modules.add(new RtModuleSetup(node2));
                    continue;
                }
                if (!string.equals("reverse")) continue;
                this.reverse.add(new RtModuleSetup(node2));
            }
            for (Node node2 : XmlParserHelper.getNodeList(node, "model")) {
                this.models.add(new RtModel(node2));
            }
        }

        public void add(RtModel rtModel) {
            this.models.add(rtModel);
        }

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "model");
            element2.setAttribute("name", this.name);
            this.forward.save(element2, "forward");
            this.modules.save(element2, "model");
            this.reverse.save(element2, "reverse");
            for (RtModel rtModel : this.models) {
                rtModel.save(element2);
            }
        }

        public RtModuleSetupList getForward() {
            return this.forward;
        }

        public RtModuleSetupList getReverse() {
            return this.reverse;
        }

        public RtModuleSetupList getModules() {
            return this.modules;
        }

        public RtModuleSetup getModule(String string) {
            return this.modules.getModule(string);
        }

        public List<RtModel> getModels() {
            return this.models;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class RtParameterMatrix
    extends RtParameter {
        private final FloatMatrix matrix;

        public RtParameterMatrix(String string, FloatMatrix floatMatrix) {
            super(string);
            this.matrix = floatMatrix;
        }

        public RtParameterMatrix(Node node) {
            super(XmlParserHelper.getAttribute(node, "name"));
            this.matrix = new FloatMatrix(RtParameterMatrix.parseFloatArray(node.getTextContent()));
        }

        public static float[][] parseFloatArray(String string) {
            float[][] fArray = null;
            if (string.length() > 0) {
                String[] stringArray = string.split("[\\[\\],]");
                int n = (int)Double.parseDouble(stringArray[1]);
                int n2 = (int)Double.parseDouble(stringArray[2]);
                fArray = new float[n][n2];
                int n3 = 0;
                int n4 = 3;
                while (n4 < stringArray.length) {
                    int n5 = n3 / n2;
                    int n6 = n3 % n2;
                    fArray[n5][n6] = Float.parseFloat(stringArray[n4]);
                    ++n4;
                    ++n3;
                }
            }
            return fArray;
        }

        @Override
        void saveLocal(Element element) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.matrix != null) {
                stringBuilder.append("[");
                stringBuilder.append(this.matrix.rows);
                stringBuilder.append(",");
                stringBuilder.append(this.matrix.columns);
                stringBuilder.append("]");
                boolean bl = false;
                for (int i = 0; i < this.matrix.rows; ++i) {
                    for (int j = 0; j < this.matrix.columns; ++j) {
                        if (bl) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append(this.matrix.get(i, j));
                        bl = true;
                    }
                }
            }
            element.setTextContent(stringBuilder.toString());
        }

        @Override
        String getType() {
            return "matrix";
        }
    }

    public static class RtParameterStringArray
    extends RtParameter {
        private final List<String> list = new ArrayList<String>();

        public RtParameterStringArray(String string, String[] stringArray) {
            super(string);
            this.list.addAll(Arrays.asList(stringArray));
        }

        public RtParameterStringArray(Node node) {
            super(XmlParserHelper.getAttribute(node, "name"));
            for (Node node2 : XmlParserHelper.getNodeList(node, "value")) {
                this.list.add(node2.getTextContent());
            }
        }

        @Override
        public void saveLocal(Element element) {
            for (String string : this.list) {
                XmlParserHelper.addElement((Node)element, "value", string);
            }
        }

        @Override
        String getType() {
            return "sarray";
        }
    }

    public static class RtParameterString
    extends RtParameter {
        private final String value;

        public RtParameterString(String string, String string2) {
            super(string);
            this.value = string2;
        }

        public RtParameterString(Node node) {
            super(XmlParserHelper.getAttribute(node, "name"));
            this.value = node.getTextContent();
        }

        @Override
        public void saveLocal(Element element) {
            element.setTextContent(this.value);
        }

        public String getValue() {
            return this.value;
        }

        @Override
        String getType() {
            return "string";
        }
    }

    public static class RtParameterVector
    extends RtParameter {
        private final double[] vector;

        public RtParameterVector(String string, double[] dArray) {
            super(string);
            this.vector = dArray;
        }

        public RtParameterVector(String string, float[] fArray) {
            super(string);
            if (fArray != null) {
                this.vector = new double[fArray.length];
                for (int i = 0; i < this.vector.length; ++i) {
                    this.vector[i] = fArray[i];
                }
            } else {
                this.vector = new double[0];
            }
        }

        public RtParameterVector(String string, int[] nArray) {
            super(string);
            this.vector = new double[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.vector[i] = nArray[i];
            }
        }

        public RtParameterVector(Node node) {
            super(XmlParserHelper.getAttribute(node, "name"));
            String[] stringArray = node.getTextContent().split(",");
            this.vector = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.vector[i] = RtDataFormat.toNumber(stringArray[i]);
            }
        }

        @Override
        public void saveLocal(Element element) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.vector != null) {
                for (double d : this.vector) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append((float)d);
                }
            }
            element.setTextContent(stringBuilder.toString());
        }

        @Override
        String getType() {
            return "vector";
        }
    }

    public static class RtParameterScalar
    extends RtParameter {
        private double scalar;

        public RtParameterScalar(String string, double d) {
            super(string);
            this.scalar = d;
        }

        public void setScalar(double d) {
            this.scalar = d;
        }

        public RtParameterScalar(Node node) {
            super(XmlParserHelper.getAttribute(node, "name"));
            this.scalar = RtDataFormat.toNumber(node.getTextContent());
        }

        @Override
        public void saveLocal(Element element) {
            element.setTextContent(Float.toString((float)this.scalar));
        }

        @Override
        String getType() {
            return "value";
        }
    }

    public static abstract class RtParameter {
        private final String name;

        public RtParameter(String string) {
            this.name = string;
        }

        abstract void saveLocal(Element var1);

        abstract String getType();

        public void save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "parameter");
            element2.setAttribute("name", this.name);
            element2.setAttribute("type", this.getType());
            this.saveLocal(element2);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class RtModuleSetup {
        private String name;
        private final List<RtParameter> parameters = new ArrayList<RtParameter>();

        public RtModuleSetup(String string) {
            this.name = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public RtModuleSetup(Node node) {
            this.name = XmlParserHelper.getAttribute(node, "name");
            for (Node node2 : XmlParserHelper.getNodeList(node, "parameter")) {
                this.parameters.add(this.createParameter(node2));
            }
        }

        private RtParameter createParameter(Node node) {
            String string = XmlParserHelper.getAttribute(node, "type");
            if (string.equals("value")) {
                return new RtParameterScalar(node);
            }
            if (string.equals("vector")) {
                return new RtParameterVector(node);
            }
            if (string.equals("matrix")) {
                return new RtParameterMatrix(node);
            }
            if (string.equals("string")) {
                return new RtParameterString(node);
            }
            if (string.equals("sarray")) {
                return new RtParameterStringArray(node);
            }
            throw new RuntimeException("No such type " + string);
        }

        public void add(RtParameter rtParameter) {
            this.parameters.add(rtParameter);
        }

        public void save(Element element, String string) {
            Element element2 = XmlParserHelper.addElement(element, "module");
            element2.setAttribute("name", this.name);
            element2.setAttribute("type", string);
            for (RtParameter rtParameter : this.parameters) {
                rtParameter.save(element2);
            }
        }

        public double getScalar(String string) {
            return ((RtParameterScalar)this.getParameter((String)string)).scalar;
        }

        public int getScalarInt(String string) {
            return (int)this.getScalar(string);
        }

        public double[] getVector(String string) {
            return ((RtParameterVector)this.getParameter((String)string)).vector;
        }

        public int[] getVectorInt(String string) {
            float[] fArray = this.getVectorFloat(string);
            int[] nArray = new int[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                nArray[i] = (int)fArray[i];
            }
            return nArray;
        }

        public float[] getVectorFloat(String string) {
            double[] dArray = ((RtParameterVector)this.getParameter((String)string)).vector;
            float[] fArray = new float[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                fArray[i] = (float)dArray[i];
            }
            return fArray;
        }

        public double getVector(String string, int n) {
            return ((RtParameterVector)this.getParameter((String)string)).vector[n];
        }

        public List<String> getStringArray(String string) {
            RtParameter rtParameter = this.getParameter(string);
            if (rtParameter instanceof RtParameterStringArray) {
                return ((RtParameterStringArray)rtParameter).list;
            }
            return Arrays.asList(((RtParameterString)rtParameter).value.split(","));
        }

        public String getString(String string) {
            return ((RtParameterString)this.getParameter((String)string)).value;
        }

        public FloatMatrix getMatrix(String string) {
            return ((RtParameterMatrix)this.getParameter((String)string)).matrix;
        }

        public RtParameter getParameter(String string) {
            RtParameter rtParameter = this.getParameterNull(string);
            if (rtParameter != null) {
                return rtParameter;
            }
            throw new RuntimeException("No such parameter: " + string);
        }

        public boolean hasParameter(String string) {
            return this.getParameterNull(string) != null;
        }

        private RtParameter getParameterNull(String string) {
            for (RtParameter rtParameter : this.parameters) {
                if (!rtParameter.getName().equalsIgnoreCase(string)) continue;
                return rtParameter;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class RtModuleSetupList
    implements Iterable<RtModuleSetup> {
        private final List<RtModuleSetup> list = new ArrayList<RtModuleSetup>();

        public void save(Element element, String string) {
            for (RtModuleSetup rtModuleSetup : this.list) {
                rtModuleSetup.save(element, string);
            }
        }

        public void add(RtModuleSetup rtModuleSetup) {
            this.list.add(rtModuleSetup);
        }

        public void addAll(List<RtModuleSetup> list) {
            this.list.addAll(list);
        }

        public void insert(RtModuleSetup rtModuleSetup) {
            this.list.add(0, rtModuleSetup);
        }

        public boolean hasModule(String string) {
            return this.getModuleNoThrow(string) != null;
        }

        public RtModuleSetup getModule(String string) {
            RtModuleSetup rtModuleSetup = this.getModuleNoThrow(string);
            if (rtModuleSetup != null) {
                return rtModuleSetup;
            }
            throw new RuntimeException("No such module: " + string);
        }

        private RtModuleSetup getModuleNoThrow(String string) {
            for (RtModuleSetup rtModuleSetup : this.list) {
                if (!rtModuleSetup.getName().equalsIgnoreCase(string)) continue;
                return rtModuleSetup;
            }
            return null;
        }

        @Override
        public Iterator<RtModuleSetup> iterator() {
            return this.list.iterator();
        }
    }
}

