/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.action;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.action.AbstractActionFunction;
import se.prediktera.breeze.common.realtime.action.AbstractActionInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.entry.workflow.Workflow;

public class WebserviceAction
extends AbstractActionFunction {
    private WebServiceParameter serviceName;

    public WebserviceAction(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(new TextParameter("host", "IP / Host", "", ""));
        this.addParameter(new TextParameter("path", "Path", "", ""));
        this.addParameter(new TextParameter("username", "User name", "", "(Optional)"));
        this.addParameter(new TextParameter("password", "Password", "", "(Optional)"));
        this.serviceName = new WebServiceParameter();
        this.addParameter(this.serviceName);
        this.serviceName.setVisible(false);
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Web service";
    }

    public static class WebServiceParameter
    extends TextParameter {
        private final List<AbstractWebService> services = new ArrayList<AbstractWebService>();

        public WebServiceParameter() {
            super("service", "Service", "", "");
            this.services.add(new PLCWebService());
            this.services.add(new AbbRobotWebService());
            this.services.add(new AWSWebService());
        }

        public AbstractWebService getWebService() {
            return (AbstractWebService)this.getValueObj();
        }

        @Override
        public Object getValueObj() {
            String string = this.getValueStr();
            for (AbstractWebService abstractWebService : this.services) {
                if (!abstractWebService.toString().equals(string)) continue;
                return abstractWebService;
            }
            return super.getValueObj();
        }

        @Override
        public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
            return this.services.toArray();
        }
    }

    public static class Info
    extends AbstractActionInfo {
        @Override
        public String getImageIcon() {
            return "web";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new WebserviceAction(this);
        }

        public String toString() {
            return "WebserviceAction";
        }

        @Override
        public String getShortDescription() {
            return "Web service";
        }

        @Override
        public String getDescription() {
            return "POST object information to web service";
        }

        @Override
        public String getHelp() {
            return "web-service";
        }
    }

    public static class AWSWebService
    extends AbstractWebService {
        public String toString() {
            return "AWS";
        }
    }

    public static class PLCWebService
    extends AbstractWebService {
        public String toString() {
            return "PLC";
        }
    }

    public static class AbbRobotWebService
    extends AbstractWebService {
        public String toString() {
            return "ABB Robot";
        }
    }

    public static abstract class AbstractWebService {
        private DescriptorTreeNode descriptorTreeNode;

        public JSONObject createJson(BasicSample basicSample, RtFrameStackList rtFrameStackList) {
            RtSpatialObject rtSpatialObject = basicSample.getCachedSpatialObject();
            Rectangle rectangle = rtSpatialObject.getBoundingBox();
            long l = rtFrameStackList.getFrameStack(rectangle.y).getFrameNumber();
            long l2 = rtFrameStackList.getFrameStack(rectangle.y + rectangle.height).getFrameNumber();
            float f = basicSample.getDescriptorHolder().getDescriptorValue(this.descriptorTreeNode);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("startFrameNumber", l);
            jSONObject.put("endFrameNumber", l2);
            jSONObject.put("class", (int)f);
            return jSONObject;
        }

        public void setDescriptorTreeNode(DescriptorTreeNode descriptorTreeNode) {
            this.descriptorTreeNode = descriptorTreeNode;
        }
    }
}

