/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.util.Collections;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;

public abstract class AbstractModelDescriptor
extends AbstractDescriptor {
    private final AnalyseParameter analyseParameter = new AnalyseParameter("analyse", this.getModelTypes());
    protected final AnalyseFactorParameter factorParameter;

    public AbstractModelDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.analyseParameter);
        this.factorParameter = new AnalyseFactorParameter("factor", this);
        this.addParameter(this.factorParameter);
    }

    public List<BasicAnalyse.ModelType> getModelTypes() {
        return Collections.singletonList(this.getModelType());
    }

    public abstract BasicAnalyse.ModelType getModelType();

    public void setAnalyse(BasicAnalyse basicAnalyse) {
        this.analyseParameter.setValueStr(basicAnalyse.getUid());
    }

    @Override
    public String getAnalyseUid() {
        return this.analyseParameter.getValueStr();
    }

    @Override
    public BasicAnalyse getAnalyse() {
        return this.analyseParameter.getAnalyse();
    }

    @Override
    public String getFactorUid(int n) {
        return this.factorParameter.getValueStr();
    }

    public void setFactor(Factor factor) {
        this.factorParameter.setValueStr(factor.getUid());
    }

    @Override
    public Factor getFactor(int n) {
        String string = this.factorParameter.getValueStr();
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse != null) {
            return basicAnalyse.getFactorHolder().getFactorByUid(string);
        }
        return null;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        String string = this.getNodeStringLocal(functionTreeNode, n, textType);
        if (!this.isAverage()) {
            return this.formatNodeStringUsingOutputs(functionTreeNode, string, textType, n);
        }
        return string;
    }

    private String getNodeStringLocal(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        Factor factor;
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse != null && (factor = basicAnalyse.getFactorHolder().getFactorByUid(this.factorParameter.getValueStr())) != null) {
            return factor.getName();
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    private String formatNodeStringUsingOutputs(FunctionTreeNode functionTreeNode, String string, FunctionTreeNode.TextType textType, int n) {
        String[] stringArray = this.getOutputs();
        if (stringArray != null && n >= 0) {
            String string2 = RtDataFormat.initialLetter(stringArray[n]);
            if (textType.equals((Object)FunctionTreeNode.TextType.Simple) && this.parentSameFactor(functionTreeNode)) {
                return string2;
            }
            return string2 + " - " + string;
        }
        return string;
    }

    private boolean parentSameFactor(FunctionTreeNode functionTreeNode) {
        Object object;
        String string = this.getFactorUid(0);
        if (string != null && (object = functionTreeNode.getParent()) instanceof DescriptorTreeNode) {
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)object;
            object = descriptorTreeNode.getFactorUid();
            return string.equals(object);
        }
        return false;
    }

    public boolean isAverage() {
        return true;
    }

    public boolean isCalculatePixel() {
        return true;
    }

    @Override
    public String getGroup() {
        Factor factor = this.getFactor(0);
        if (factor != null) {
            return factor.getName();
        }
        return null;
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse instanceof Analyse) {
            return ((Analyse)basicAnalyse).getTransformations();
        }
        return null;
    }
}

