/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.util.List;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.ClassParameterDescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.CountEntryByClassDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ClassParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class AreaByClassDescriptor
extends CountEntryByClassDescriptor
implements ClassParameterDescriptorInterface {
    public AreaByClassDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        BasicSample basicSample = (BasicSample)descriptorInterface;
        String string = ((IDParameter)this.getParameterByIndex(0)).getId();
        ClassParameter classParameter = (ClassParameter)this.getParameterByIndex(1);
        BooleanParameter booleanParameter = (BooleanParameter)this.getParameterByIndex(2);
        CatClass catClass = classParameter.getCatClass(functionTreeNode);
        List<BasicSample> list = basicSample.getChildList();
        if (list.isEmpty() || catClass == null) {
            return new float[]{0.0f};
        }
        int n = catClass.getValueIdx();
        float f = 0.0f;
        for (BasicSample basicSample2 : list) {
            float f2 = this.getValue(basicSample2, string);
            if (f2 != (float)n) continue;
            f += (float)basicSample2.getCachedSpatialObject().getArea();
        }
        RtSpatialObject rtSpatialObject2 = basicSample.getCachedSpatialObject();
        if (booleanParameter.getValueBool()) {
            f /= (float)rtSpatialObject2.getArea();
        } else {
            float f3 = rtSpatialObject2.getResolution();
            f = f * f3 * f3;
        }
        return new float[]{f};
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        BooleanParameter booleanParameter = (BooleanParameter)this.getParameterByIndex(2);
        if (!booleanParameter.getValueBool()) {
            return " mm\u00b2";
        }
        return super.getUnit(functionTreeNode, n);
    }

    @Override
    protected String getNamePrefix() {
        return "Area";
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "area";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new AreaByClassDescriptor(this);
        }

        public String toString() {
            return "AreaByClass";
        }

        @Override
        public String getDescription() {
            return "Area of subsamples by a given class";
        }

        @Override
        public String getShortDescription() {
            return "Area of subsamples";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "area-of-subsamples-by-a-given-class";
        }
    }
}

