/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.awt.Graphics;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseFactorParameter;
import se.prediktera.breeze.common.realtime.unmixing.ConstrainedSpectralUnmixerSetting;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.entry.sample.Sample;

public class ConstrainedSpectralUnmixerDescriptor
extends AbstractDescriptor
implements ConstrainedSpectralUnmixerSetting.ContrainedUnmixingInterface,
ThumbnailDescriptor.ThumbnailQuantificationDescriptor,
CustomRenderingDescriptor {
    private final AnalyseFactorParameter factorParameter = new AnalyseFactorParameter("factor", this);
    private final ConstrainedSpectralUnmixerSetting setting;
    private final PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;

    public ConstrainedSpectralUnmixerDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.factorParameter, 4);
        this.setting = new ConstrainedSpectralUnmixerSetting(this, true);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.addOutput("value");
        this.factorParameter.setVisible(this::isQuantification);
        this.smoothParameter.setVisible(this::isQuantification);
        this.setting.getExpressionParameter().setVisible(this::isQuantification);
    }

    @Override
    public BasicAnalyse getAnalyse() {
        return this.setting.getOrCreateAnalyse(this.getNode());
    }

    @Override
    public Factor getFactor(int n) {
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse != null) {
            if (this.isQuantification()) {
                String string = this.factorParameter.getValueStr();
                return basicAnalyse.getFactorHolder().getFactorByUid(string);
            }
            return basicAnalyse.getCategoryFactor();
        }
        return null;
    }

    public boolean isQuantification() {
        return this.setting.isQuantification();
    }

    public boolean isClassification() {
        return !this.isQuantification();
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse != null) {
            if (this.isQuantification()) {
                PropertyFactor propertyFactor = basicAnalyse.getPropertyFactors().getByUid(this.factorParameter.getValueStr());
                if (propertyFactor != null) {
                    return propertyFactor.getName();
                }
            } else {
                CategoryFactor categoryFactor = basicAnalyse.getCategoryFactor();
                if (categoryFactor != null) {
                    return categoryFactor.getName();
                }
            }
        }
        return "Unmixing";
    }

    @Override
    public ConstrainedSpectralUnmixerSetting getSetting() {
        return this.setting;
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        if (this.isQuantification()) {
            return ThumbnailDescriptor.ThumbType.ThumbQuantification;
        }
        return ThumbnailDescriptor.ThumbType.ThumbClassification;
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor;
        CatClass catClass;
        Factor factor = this.getFactor(n);
        if (this.isClassification() && factor instanceof CategoryFactor && (catClass = (categoryFactor = (CategoryFactor)factor).getClassByValueIdx((int)f)) != null) {
            return catClass.getName();
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public boolean renderCellAt(int n) {
        return this.isClassification();
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        CategoryFactor categoryFactor;
        Factor factor;
        if (this.isClassification() && (factor = this.getFactor(n3)) instanceof CategoryFactor && (categoryFactor = (CategoryFactor)factor) != null) {
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string);
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "waves";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new ConstrainedSpectralUnmixerDescriptor(this);
        }

        public String toString() {
            return "UnmixerDescriptor";
        }

        @Override
        public String getDescription() {
            return "Constrained Spectral Unmixing";
        }

        @Override
        public String getShortDescription() {
            return "Unmixing";
        }

        @Override
        public String getHelp() {
            return "constrained-spectral-unmixing-segmentation";
        }
    }
}

