/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.util.List;
import se.prediktera.breeze.common.entry.ObjectWithChildrenAndParent;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.ClassParameterDescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ClassParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.image.RtSpatialObject;

public class CountEntryByClassDescriptor
extends AbstractDescriptor
implements ClassParameterDescriptorInterface {
    private final IDParameter idParameter = new IDParameter.ChildIDParameter();
    private final ClassParameter classParameter;
    private final BooleanParameter percentParameter;

    public CountEntryByClassDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.idParameter);
        this.classParameter = new ClassParameter("class", "id", this);
        this.addParameter(this.classParameter);
        this.percentParameter = new BooleanParameter("percent", false);
        this.addParameter(this.percentParameter);
        this.addOutput("value");
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        ObjectWithChildrenAndParent objectWithChildrenAndParent = (ObjectWithChildrenAndParent)((Object)descriptorInterface);
        String string = this.idParameter.getId();
        CatClass catClass = this.classParameter.getCatClass(functionTreeNode);
        List list = objectWithChildrenAndParent.getChildList();
        if (list.isEmpty() || catClass == null) {
            return new float[]{0.0f};
        }
        int n = catClass.getValueIdx();
        float f = 0.0f;
        for (ObjectWithChildrenAndParent objectWithChildrenAndParent2 : list) {
            float f2 = this.getValue((DescriptorInterface)((Object)objectWithChildrenAndParent2), string);
            if (f2 != (float)n) continue;
            f += 1.0f;
        }
        if (this.percentParameter.getValueBool()) {
            f /= (float)list.size();
        }
        return new float[]{f};
    }

    protected float getValue(DescriptorInterface descriptorInterface, String string) {
        FunctionResult functionResult = descriptorInterface.getFunctionResult(string);
        if (functionResult != null) {
            return functionResult.getValue();
        }
        return 0.0f;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        BooleanParameter booleanParameter = (BooleanParameter)this.getParameterByIndex(2);
        if (booleanParameter.getValueBool()) {
            return RtDataFormat.toPercent(f, false);
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        BooleanParameter booleanParameter = (BooleanParameter)this.getParameterByIndex(2);
        if (booleanParameter.getValueBool()) {
            return "%";
        }
        return super.getUnit(functionTreeNode, n);
    }

    @Override
    public MinMax getMinMax(int n) {
        BooleanParameter booleanParameter = (BooleanParameter)this.getParameterByIndex(2);
        if (booleanParameter.getValueBool()) {
            return new MinMax(0.0f, 1.0f);
        }
        return null;
    }

    protected String getNamePrefix() {
        return "Count";
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        CategoryFactor categoryFactor = this.getCategoryFactor(functionTreeNode);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getNamePrefix());
        if (categoryFactor != null) {
            BooleanParameter booleanParameter;
            stringBuilder.append(" (");
            ClassParameter classParameter = (ClassParameter)this.getParameterByName("class");
            CatClass catClass = classParameter.getCatClass(functionTreeNode);
            if (catClass != null) {
                stringBuilder.append(catClass.getName());
            }
            if ((booleanParameter = (BooleanParameter)this.getParameterByIndex(2)).getValueBool()) {
                stringBuilder.append("%");
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public CategoryFactor getCategoryFactor(FunctionTreeNode functionTreeNode) {
        Factor factor;
        IDParameter iDParameter = (IDParameter)this.getParameterByName("id");
        FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
        FunctionTreeNodeWithId functionTreeNodeWithId = functionTreeNode2.getNodeById(iDParameter.getId());
        if (functionTreeNodeWithId != null && (factor = functionTreeNodeWithId.getFactor()) instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            return categoryFactor;
        }
        return null;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "count";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new CountEntryByClassDescriptor(this);
        }

        public String toString() {
            return "CountEntryByClass";
        }

        @Override
        public String getDescription() {
            return "Number of subsamples by given class";
        }

        @Override
        public String getShortDescription() {
            return "Subsamples by given class";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Statistic;
        }

        @Override
        public String getHelp() {
            return "number-of-subsamples-by-a-given-class";
        }
    }
}

