/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.EvaluationTree;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.TreeListInterface;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.model.ModelDataDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.TrainTestDescriptor;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.sample.Sample;

public class DescriptorHolder {
    private final HashMap<String, FunctionResult> hashMap = new HashMap();
    private final DescriptorInterface descriptor;

    public DescriptorHolder(DescriptorInterface descriptorInterface) {
        this.descriptor = descriptorInterface;
    }

    public float getDescriptorValue(DescriptorTreeNode descriptorTreeNode) {
        FunctionResult functionResult = this.hashMap.get(descriptorTreeNode.getUid());
        if (functionResult != null) {
            return functionResult.getValue();
        }
        return 0.0f;
    }

    public boolean hasDescriptorValue(DescriptorTreeNode descriptorTreeNode) {
        return this.hashMap.containsKey(descriptorTreeNode.getUid());
    }

    public FunctionResult getFunctionResult(String string) {
        return this.hashMap.get(string);
    }

    public void putFunctionResult(String string, FunctionResult functionResult) {
        this.hashMap.put(string, functionResult);
    }

    public Set<Map.Entry<String, FunctionResult>> entrySet() {
        return this.hashMap.entrySet();
    }

    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    public void writeResults(Node node) {
        Element element = XmlParserHelper.addElement(node, "values");
        for (FunctionResult functionResult : this.hashMap.values()) {
            functionResult.writeXmlNode(element);
        }
    }

    public void parseResults(Node node, TreeListInterface treeListInterface) {
        Node node2 = XmlParserHelper.getNode(node, "values", null);
        if (node2 != null) {
            List<Node> list = XmlParserHelper.getNodeList(node2, "value", null);
            for (Node node3 : list) {
                DescriptorInterface descriptorInterface;
                String string = XmlParserHelper.getId(node3);
                FunctionTreeNodeWithId functionTreeNodeWithId = treeListInterface.getTreeNodeById(string);
                if (!(functionTreeNodeWithId instanceof DescriptorTreeNode)) continue;
                DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNodeWithId;
                if (descriptorTreeNode.getFunction() instanceof TrainTestDescriptor && (descriptorInterface = this.descriptor) instanceof Sample) {
                    Sample sample = (Sample)descriptorInterface;
                    this.putFunctionResult(string, new TrainTestDescriptor.TrainTestFunctionResult(descriptorTreeNode, node3, sample));
                    continue;
                }
                if (descriptorTreeNode.getFunction() instanceof ModelDataDescriptor && (descriptorInterface = this.descriptor) instanceof Sample) {
                    Sample sample = (Sample)descriptorInterface;
                    this.putFunctionResult(string, new ModelDataDescriptor.ModelDataFunctionResult(descriptorTreeNode, node3, sample));
                    continue;
                }
                if (PlsPredQuantificationDescriptor.ConnectedQuantificationFunctionResult.isHierarchical(descriptorTreeNode) && (descriptorInterface = this.descriptor) instanceof Sample) {
                    Sample sample = (Sample)descriptorInterface;
                    this.putFunctionResult(string, new PlsPredQuantificationDescriptor.ConnectedQuantificationFunctionResult(descriptorTreeNode, node3, sample));
                    continue;
                }
                this.putFunctionResult(string, new FunctionResult(descriptorTreeNode, node3));
            }
        }
    }

    public boolean hasResultForAllDescriptors(EvaluationTree evaluationTree) {
        for (DescriptorTreeNode descriptorTreeNode : evaluationTree.getDescriptorNodes()) {
            FunctionResult functionResult = this.getFunctionResult(descriptorTreeNode.getUid());
            if (functionResult != null && !functionResult.isMissing()) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.hashMap.clear();
    }
}

