/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.util.StringHelper;

public class MetaDataDescriptor
extends AbstractDescriptor {
    public MetaDataDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        for (MetaData metaData : MetaData.values()) {
            this.addOutput(metaData.toString());
        }
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return StringHelper.formatLabel(this.getOutputString(n));
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return MetaData.values()[n].getUnit();
    }

    public static enum MetaData {
        Frames,
        MaxSignal,
        FrameRate,
        Wavelength,
        IntegrationTime(" \u00b5s"),
        Length(" mm"),
        PixelsPerLine(" px"),
        FieldOfView(" mm"),
        Resolution(" mm/px"),
        Speed(" mm/sec"),
        DroppedFrames,
        FileSize(" mb");

        private String unit;

        private MetaData() {
            this(null);
        }

        private MetaData(String string2) {
            this.unit = string2;
        }

        public String getUnit() {
            return this.unit;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "metadata";
        }

        @Override
        public MetaDataDescriptor createFunction() {
            return new MetaDataDescriptor(this);
        }

        public String toString() {
            return "MetaDataValues";
        }

        @Override
        public String getShortDescription() {
            return "Metadata";
        }

        @Override
        public String getDescription() {
            return "Metadata from measurement";
        }

        @Override
        public String getHelp() {
            return "metadata-from-measurement";
        }
    }
}

