/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import se.prediktera.breeze.common.entry.tree.evaluatetree.AbstractEvaluate;
import se.prediktera.breeze.common.entry.tree.evaluatetree.AbstractEvaluateInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.util.raw.RawFile;
import se.prediktera.breeze.common.util.type.MaxSignal;
import se.prediktera.breeze.entry.measurement.Measurement;

public class MetaDataEvaluate
extends AbstractEvaluate {
    public MetaDataEvaluate(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(new TextParameter("metakey", ""));
        this.addOutput("value");
    }

    @Override
    public double evaluate(FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface) {
        Measurement measurement = (Measurement)descriptorInterface;
        String string = this.getParameterByIndex(0).getValueStr();
        try {
            return Float.parseFloat(measurement.getMetaValue(string));
        }
        catch (NumberFormatException numberFormatException) {
            RawFile rawFile;
            if (string.equals("MaxSignal")) {
                return MaxSignal.DEFAULT.value;
            }
            if (string.equals("DroppedFrames")) {
                return 0.0;
            }
            if (string.equals("Frames") && (rawFile = measurement.rawFile()) != null) {
                return rawFile.header().frameCount().value;
            }
            throw new RuntimeException(numberFormatException);
        }
    }

    public static class Info
    extends AbstractEvaluateInfo {
        @Override
        public AbstractBreezeFunction createFunction() {
            return new MetaDataEvaluate(this);
        }

        public String toString() {
            return "MetaData";
        }
    }
}

