/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.type.BandNames;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailPropertyMwl;
import se.prediktera.map.register.RegInfo;

public class MwlDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor,
AddParameter.AddFunctionWithAliasInterface {
    private final String version = "1";
    private final TextParameter rangeParameter = new TextParameter("range", "Continuum end points", "", "Eg: 460:980 or empty = all");
    private final NumberParameter numPeaksParameter;
    private final NumberParameter thresholdParameter;
    private final WorkflowAnalyseParameter analyseParameter;
    private final PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;
    private final TransformationParameter transformationParameter;
    private final BooleanParameter resultParameter;
    private TextParameter visualizationRangeParameter;

    public MwlDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.rangeParameter, 3);
        this.visualizationRangeParameter = new TextParameter("visrange", "Feature range (Optional)", "", "");
        this.addParameter(this.visualizationRangeParameter, 3);
        this.numPeaksParameter = new NumberParameter("numpeaks", "Number of peaks", 1.0, "");
        this.addParameter(this.numPeaksParameter);
        this.thresholdParameter = new NumberParameter("threshold", "Depth threshold", 0.0, "");
        this.addParameter(this.thresholdParameter);
        this.transformationParameter = new TransformationParameter(true);
        this.addParameter(this.transformationParameter);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter, 2);
        this.analyseParameter.setVisible(false);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.resultParameter = new AddParameter(this, "Show median depth and wavelength", true, null);
        this.addParameter(this.resultParameter);
        this.numPeaksParameter.setEditable(() -> !this.resultParameter.getValueBool());
        for (int i = 1; i <= 5; ++i) {
            this.addOutput("feature" + i + "Depth");
            this.addOutput("feature" + i + "Position");
        }
    }

    @Override
    public AddParameter.AddNodeList getAddNodes() {
        AddParameter.AddNodeList addNodeList = new AddParameter.AddNodeList();
        for (int i = 1; i < this.getAnalyse().getPropertyFactors().size(); ++i) {
            DescriptorTreeNode descriptorTreeNode = new DescriptorTreeNode();
            descriptorTreeNode.setFunction(this.clone());
            descriptorTreeNode.setIndex(i);
            addNodeList.add(new AddParameter.AddNode(descriptorTreeNode, this.getNode()));
        }
        return addNodeList;
    }

    @Override
    public boolean support(AbstractBreezeFunction abstractBreezeFunction) {
        return abstractBreezeFunction instanceof MwlDescriptor;
    }

    @Override
    public boolean showOutputs() {
        return false;
    }

    @Override
    public boolean isVisible(int n) {
        return n == 0 || !this.resultParameter.getValueBool();
    }

    @Override
    public RtAnalyse getAnalyse() {
        return this.getOrCreateAnalyse(this.getNode());
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    private int getParameterHashCode(String string, FunctionTreeNodeWithId functionTreeNodeWithId) {
        int n = StringHelper.hashCode(string);
        n += StringHelper.hashCode(this.getNodeOrParent(functionTreeNodeWithId).getUid());
        return n += FunctionParameter.hashCode(this.rangeParameter, this.visualizationRangeParameter, this.numPeaksParameter, this.thresholdParameter, this.transformationParameter);
    }

    public RtAnalyse getOrCreateAnalyse(FunctionTreeNodeWithId functionTreeNodeWithId) {
        String string = this.getStudyId();
        return MembersSetting.createAnalyse(functionTreeNodeWithId, "Mwl_" + this.getParameterHashCode(string, functionTreeNodeWithId), this.analyseParameter, string2 -> {
            List<float[]> list = this.getVisualizationRange();
            BandNames bandNames = this.getBandNames(functionTreeNodeWithId, list);
            RtAnalyse rtAnalyse = new RtAnalyse(string2, "MWL - " + this.getStudyName() + " (" + bandNames.getFormatedRange() + ")", BasicAnalyse.ModelMethod.QuantificationMwl, string, "1");
            for (int i = 0; i < this.numPeaksParameter.getValueInt(); ++i) {
                PropertyFactorMwl propertyFactorMwl = new PropertyFactorMwl("Feature " + (i + 1) + " depth", "MwlFeature" + i, bandNames, list, this.thresholdParameter.getValueFloat());
                propertyFactorMwl.setMax(0.5f);
                propertyFactorMwl.setDynamicMinMax(true);
                rtAnalyse.getPropertyFactors().add(propertyFactorMwl);
                PropertyFactor propertyFactor = new PropertyFactor("Feature " + (i + 1) + " position", "MwlBand" + i, "");
                rtAnalyse.getPropertyFactors().add(propertyFactor);
                propertyFactorMwl.setBandFactor(propertyFactor);
            }
            rtAnalyse.setObjectMethod(this);
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(this.createRtModel(false));
            rtAnalyse.setModelParameters(rtModelParameters);
            return rtAnalyse;
        });
    }

    public BandNames getVisualizationBandNames() {
        return this.getBandNames(this.getNode(), this.getVisualizationRange());
    }

    private List<float[]> getVisualizationRange() {
        String string = this.visualizationRangeParameter.getText();
        if (string.length() > 0) {
            return MembersSetting.getRange(this, this.visualizationRangeParameter, false);
        }
        return MembersSetting.getRange(this, this.rangeParameter, false);
    }

    public boolean hasRangeLimits() {
        return StringUtils.isNotEmpty((CharSequence)this.rangeParameter.getText());
    }

    private BandNames getBandNames(FunctionTreeNode functionTreeNode, List<float[]> list) {
        BandNames bandNames = this.getMeasurementBandNames();
        BandNames bandNames2 = new BandNames(new String[0]);
        if (list.isEmpty()) {
            if (bandNames != null) {
                return bandNames;
            }
        } else {
            float[] fArray = list.get(0);
            if (fArray[0] == -1.0f) {
                if (bandNames != null) {
                    return bandNames;
                }
            } else {
                float[] fArray2 = list.get(list.size() - 1);
                float f = fArray[0];
                float f2 = fArray2[1];
                if (bandNames != null) {
                    return bandNames.getWithin(f, f2);
                }
                for (float f3 = f; f3 <= f2; f3 += 1.0f) {
                    bandNames2.add(String.valueOf(f3));
                }
            }
        }
        return bandNames2;
    }

    private BandNames getMeasurementBandNames() {
        Measurement measurement;
        Workflow workflow = this.getWorkflow();
        if (workflow != null && (measurement = workflow.getFirstMeasurementWithData()) != null) {
            return measurement.getBandNames();
        }
        return null;
    }

    public RtModelParameters.RtModel createRtModel(boolean bl) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("Mwl");
        RtModelParameters.RtModuleSetupList rtModuleSetupList = rtModel.getModules();
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        this.addRegions(rtModuleSetup, "", MembersSetting.getRange(this, this.rangeParameter, bl));
        this.addRegions(rtModuleSetup, "vis", MembersSetting.getRange(this, this.visualizationRangeParameter, bl, 0.0f, 2.1474836E9f));
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("numpeaks", this.numPeaksParameter.getValueInt()));
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("threshold", this.thresholdParameter.getValueFloat()));
        rtModuleSetupList.add(rtModuleSetup);
        return rtModel;
    }

    private void addRegions(RtModelParameters.RtModuleSetup rtModuleSetup, String string, List<float[]> list) {
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar(string + "regions", list.size()));
        for (int i = 0; i < list.size(); ++i) {
            float[] fArray = list.get(i);
            String string2 = i > 0 ? Integer.valueOf(i + 1) : "";
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar(string + "min" + String.valueOf(string2), fArray[0]));
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar(string + "max" + String.valueOf(string2), fArray[1]));
        }
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getPropertyFactors().get(n);
    }

    @Override
    public boolean hasResult(int n) {
        return this.resultParameter.getValueBool();
    }

    @Override
    public boolean hasThumbnail(int n) {
        return n % 2 == 0;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (textType.isTable()) {
            String string = StringHelper.formatLabel(this.getOutputName(n));
            if (textType.equals((Object)FunctionTreeNode.TextType.TableThumbnail)) {
                String[] stringArray = string.split(" ");
                return this.format(functionTreeNode, stringArray[0] + " " + stringArray[1]);
            }
            return this.format(functionTreeNode, string);
        }
        return "MWL";
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    @Override
    public List<AdditionalFactor> getAdditionalFactors() {
        PropertyList propertyList;
        RtAnalyse rtAnalyse;
        if (!this.resultParameter.getValueBool() && (rtAnalyse = this.getAnalyse()) != null && (propertyList = rtAnalyse.getPropertyFactors()).size() > 1) {
            ArrayList<AdditionalFactor> arrayList = new ArrayList<AdditionalFactor>();
            for (int i = 2; i < propertyList.size(); i += 2) {
                AdditionalFactor additionalFactor = new AdditionalFactor(propertyList.get(i));
                additionalFactor.setVisibleInTree(false);
                arrayList.add(additionalFactor);
            }
            return arrayList;
        }
        return null;
    }

    public static class PropertyFactorMwl
    extends PropertyFactor {
        private final BandNames bandNames;
        private PropertyFactor bandFactor;
        private final List<float[]> range;
        private final float threshold;

        public PropertyFactorMwl(String string, String string2, BandNames bandNames, List<float[]> list, float f) {
            super(string, string2, "");
            this.bandNames = bandNames;
            this.range = list;
            this.threshold = f;
        }

        public void setBandFactor(PropertyFactor propertyFactor) {
            this.bandFactor = propertyFactor;
        }

        public PropertyFactor getBandFactor() {
            return this.bandFactor;
        }

        @Override
        public Thumbnail createThumbnail(Measurement measurement, Sample sample, AbstractBreezeFunction abstractBreezeFunction, BasicAnalyse basicAnalyse, boolean bl, boolean bl2) {
            return new ThumbnailPropertyMwl(measurement, sample, basicAnalyse, this, ((ThumbnailDescriptor.ThumbnailQuantificationDescriptor)((Object)abstractBreezeFunction)).getSmooth(), bl, bl2);
        }

        public BandNames getBandNames() {
            return this.bandNames;
        }

        public List<float[]> getRange() {
            return this.range;
        }

        public float getThreshold() {
            return this.threshold;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "minimum";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new MwlDescriptor(this);
        }

        public String toString() {
            return "MwlDescriptor";
        }

        @Override
        public String getShortDescription() {
            return "MWL mapping";
        }

        @Override
        public String getDescription() {
            return "Minimum wavelength mapping";
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Geo;
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Geo;
        }

        @Override
        public String getHelp() {
            return "mwl-mapping";
        }
    }
}

