/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.DescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.function.FunctionDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.util.BreezeProgress;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.PythonHelper;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class PythonScriptDescriptor
extends AbstractDescriptor {
    private final FileParameter selectedFile = new FileParameter(this, "file", "Python file", "", "Select python script"){

        @Override
        public void customizeDialog(jopensaveDialog jopensaveDialog2) {
            jopensaveDialog2.setDialogTitle("Select python script file");
            jopensaveDialog2.setAcceptAllFileFilterUsed(true);
            FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("py", "Python script (*.py)");
            jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
            jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
        }
    };
    private final FileParameter interpreter;
    private final FunctionDescriptor.ObjectOrPixelsParameter typeParameter;

    public PythonScriptDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.selectedFile);
        this.interpreter = new FileParameter(this, "interpreter", "Python interpreter (optional)", "", "Select python interpreter (empty for system default)"){

            @Override
            public void customizeDialog(jopensaveDialog jopensaveDialog2) {
                jopensaveDialog2.setDialogTitle("Select custom python interpreter");
                if (SystemUtils.IS_OS_WINDOWS) {
                    jopensaveDialog2.setAcceptAllFileFilterUsed(true);
                    FileParameter.ExtensionFilter extensionFilter = new FileParameter.ExtensionFilter("exe", "Executable (*.exe)");
                    jopensaveDialog2.addChoosableFileFilter((FileFilter)extensionFilter);
                    jopensaveDialog2.setFileFilter((FileFilter)extensionFilter);
                }
            }
        };
        this.addParameter(this.interpreter);
        this.typeParameter = new FunctionDescriptor.ObjectOrPixelsParameter("Apply on object or pixels");
        this.addParameter(this.typeParameter);
        this.addOutput("value");
    }

    @Override
    public float[] perform(BreezeProgress breezeProgress, FunctionTreeNode functionTreeNode, DescriptorInterface descriptorInterface, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject) {
        try {
            if (this.typeParameter.isObject()) {
                BasicSample basicSample = (BasicSample)descriptorInterface;
                return PythonHelper.executePythonScript(this.interpreter.getValueStr(), this.selectedFile.getValueStr(), basicSample.getAverageProfiles()[0]);
            }
            return PythonHelper.executePythonScript(this.interpreter.getValueStr(), this.selectedFile.getValueStr(), rtFramesAndRefs.frames().getReferenceOrRawFrameList(), rtSpatialObject);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        File file = this.selectedFile.getFile(this.getWorkflow());
        if (file != null) {
            return FileHelper.getFileName(file);
        }
        return "Python";
    }

    @Generated
    public FunctionDescriptor.ObjectOrPixelsParameter getTypeParameter() {
        return this.typeParameter;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public AbstractBreezeFunction createFunction() {
            return new PythonScriptDescriptor(this);
        }

        public String toString() {
            return "PythonScript";
        }

        @Override
        public String getDescription() {
            return "Python descriptor script runner";
        }

        @Override
        public String getShortDescription() {
            return "Python script";
        }

        @Override
        public String getImageIcon() {
            return "python";
        }

        @Override
        public String getHelp() {
            return "python-script-descriptor";
        }
    }
}

