/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.map.register.RegInfo;

public class SaturationDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor {
    private final String version = "2";
    private SatTypeParameter satTypeParameter = new SatTypeParameter();
    private WorkflowAnalyseParameter analyseParameter;
    private PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;

    public SaturationDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.satTypeParameter);
        this.satTypeParameter.setVisible(false);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.addOutput("intensity");
        this.addOutput("saturation");
    }

    private int getParameterHashCode(FunctionTreeNode functionTreeNode) {
        int n = FunctionParameter.hashCode(this.satTypeParameter);
        return n += StringHelper.hashCode("2");
    }

    private RtAnalyse getOrCreateAnalyse(FunctionTreeNode functionTreeNode) {
        return MembersSetting.createAnalyse(functionTreeNode, "Sat_" + this.getParameterHashCode(functionTreeNode), this.analyseParameter, string -> {
            RtAnalyse rtAnalyse = new RtAnalyse(string, "Saturation", BasicAnalyse.ModelMethod.QuantificationSaturation, this.getStudyId(), "2");
            RtModelParameters rtModelParameters = new RtModelParameters();
            RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("Saturation");
            RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
            rtModel.getModules().add(rtModuleSetup);
            rtModuleSetup.add(new RtModelParameters.RtParameterString("type", this.satTypeParameter.getValueStr()));
            rtModelParameters.addModel(rtModel);
            rtAnalyse.setModelParameters(rtModelParameters);
            rtAnalyse.getPropertyFactors().add(new SaturationFactor("Saturated", "max", "%"));
            rtAnalyse.getPropertyFactors().add(new SaturationFactor("Bands", "percent", "%"));
            return rtAnalyse;
        });
    }

    @Override
    public RtAnalyse getAnalyse() {
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(this.getNode());
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getPropertyFactors().get(n);
    }

    @Override
    public boolean hasResult(int n) {
        return true;
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        return "%";
    }

    @Override
    public MinMax getMinMax(int n) {
        return MinMax.Percent100;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Saturation (" + this.getOutputString(n) + ")";
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        return super.getStringValue(f, n, n2);
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    public static class SatTypeParameter
    extends OptionParameter {
        public SatTypeParameter() {
            super("type", "Type", "raw", "");
            this.add(new OptionParameter.Option("raw", "Raw"));
            this.add(new OptionParameter.Option("reflectance", "Reflectance"));
        }
    }

    public static class SaturationFactor
    extends PropertyFactor {
        public SaturationFactor(String string, String string2, String string3) {
            super(string, string2, string3);
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public AbstractBreezeFunction createFunction() {
            return new SaturationDescriptor(this);
        }

        public String toString() {
            return "SaturationDescriptor";
        }

        @Override
        public String getDescription() {
            return "Saturated pixels";
        }

        @Override
        public String getImageIcon() {
            return "saturated";
        }

        @Override
        public String getHelp() {
            return "saturated-pixels";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return RegInfo.isRecordFeature() && !RegInfo.isApplicationFeature() ? AbstractCardInfo.GroupType.Recorder : null;
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Record;
        }
    }
}

