/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyseList;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.map.common.error.Logg;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class SegmentationLabelDescriptor
extends AbstractDescriptor
implements CustomRenderingDescriptor {
    private final String version = "1";
    private final WorkflowAnalyseParameter analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
    private final FileParameter fileParameter;
    private static File lastFolder;

    public SegmentationLabelDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.fileParameter = new FileParameter("file", "File", "", "Label file"){

            @Override
            public void customizeDialog(jopensaveDialog jopensaveDialog2) {
                jopensaveDialog2.addChoosableFileFilter((FileFilter)new FileNameExtensionFilter("Label text file (*.txt; *.names)", "txt", "names"));
                if (jopensaveDialog2.getSelectedFile() == null) {
                    jopensaveDialog2.setCurrentDirectory(lastFolder);
                }
            }

            @Override
            public void setValueStr(String string) {
                super.setValueStr(string);
                File file = new File(string);
                if (file.exists()) {
                    lastFolder = file.getParentFile();
                }
                SegmentationLabelDescriptor.this.getAnalyse();
            }
        };
        this.addParameter(this.fileParameter);
        this.addOutput("value");
        this.addOutput("confidence");
    }

    @Override
    public BasicAnalyse getAnalyse() {
        BasicAnalyse basicAnalyse = this.getOrCreateAnalyse(this.fileParameter.getFile(this.getWorkflow()));
        this.analyseParameter.setValue(basicAnalyse);
        return basicAnalyse;
    }

    public BasicAnalyse getOrCreateAnalyse(File file) {
        if (file != null && file.exists()) {
            RtAnalyseList rtAnalyseList = BreezeMasterCache.getRtAnalyseListOrNull();
            if (rtAnalyseList == null) {
                return null;
            }
            String string = "Label_" + StringHelper.hashCode(file.getAbsolutePath());
            BasicAnalyse basicAnalyse = (BasicAnalyse)rtAnalyseList.byId(string);
            if (basicAnalyse != null) {
                return basicAnalyse;
            }
            String string2 = FileHelper.getFileName(file);
            RtAnalyse rtAnalyse = new RtAnalyse(string, "Label (" + string2 + ")", BasicAnalyse.ModelMethod.ClassificationLabel, this.getStudyId(), "1");
            RtModelParameters rtModelParameters = new RtModelParameters();
            RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("Label");
            RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
            rtModel.getModules().add(rtModuleSetup);
            rtModelParameters.addModel(rtModel);
            rtAnalyse.setModelParameters(rtModelParameters);
            try {
                CategoryFactor categoryFactor = new CategoryFactor("Type", "LabelType");
                List<String> list = Files.readAllLines(file.toPath());
                for (String string3 : list) {
                    categoryFactor.addClass(StringHelper.formatLabel(string3));
                }
                rtAnalyse.getCategoryFactors().add(categoryFactor);
            }
            catch (IOException iOException) {
                Logg.error((String)iOException.getMessage(), (Throwable)iOException);
            }
            rtAnalyseList.add(rtAnalyse);
            return rtAnalyse;
        }
        return null;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (n == 0) {
            return "Label";
        }
        return "Confidence";
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor;
        CatClass catClass;
        Factor factor = this.getFactor(n);
        if (n == 0 && factor instanceof CategoryFactor && (catClass = (categoryFactor = (CategoryFactor)factor).getClassByValueIdx((int)f)) != null) {
            return catClass.getName();
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public boolean renderCellAt(int n) {
        return n == 0;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        CategoryFactor categoryFactor;
        if (n3 == 0 && (categoryFactor = (CategoryFactor)this.getFactor(n3)) != null) {
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string);
    }

    @Override
    public Factor getFactor(int n) {
        BasicAnalyse basicAnalyse = this.getAnalyse();
        if (basicAnalyse != null) {
            return basicAnalyse.getCategoryFactor();
        }
        return null;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "label";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new SegmentationLabelDescriptor(this);
        }

        public String toString() {
            return "LabelDescriptor";
        }

        @Override
        public String getDescription() {
            return "Segmentation label";
        }

        @Override
        public String getHelp() {
            return "segmentation-label";
        }
    }
}

