/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.RuleImageParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.spectralLibraries.GroupCatClass;
import se.prediktera.breeze.common.realtime.unmixing.GroupingUtils;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.realtime.unmixing.Reference;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;

public class SpectralAngleMapperDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor,
CustomRenderingDescriptor,
RuleImageParameter.RuleImageFunction {
    private final String version = "1";
    private final PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;
    private final MembersSetting membersSetting = new MembersSetting(this){

        @Override
        protected RtAnalyse createAnalyse(FunctionTreeNode functionTreeNode, String string) {
            Object object;
            List<Reference> list = this.getEndMembers(Workflow.getWorkflow(functionTreeNode), false);
            RtAnalyse rtAnalyse = new RtAnalyse(string, "Sam (" + MembersSetting.getFirstName(list) + ")", BasicAnalyse.ModelMethod.ClassificationSam, SpectralAngleMapperDescriptor.this.getStudyId(), "1");
            CategoryFactor categoryFactor = rtAnalyse.getCategoryFactors().add(CategoryFactor.withNoClass("Type", "SamType", Color.black));
            GroupingUtils.Grouping grouping = this.spectralLibraryGroupParameter.getGrouping();
            boolean bl = grouping != null && !grouping.isNone();
            for (Reference reference : list) {
                if (!reference.isIncluded()) continue;
                if (bl && grouping.getGroupFromEndMember(reference.getName()).isPresent()) {
                    categoryFactor.addClass(new GroupCatClass(reference.getName(), categoryFactor, grouping));
                    continue;
                }
                object = categoryFactor.addClass(reference.getName());
                if (reference.isCustomColor()) {
                    ((CatClass)object).setColor(reference.getColor());
                    continue;
                }
                reference.setColor(((CatClass)object).getColor(), false);
            }
            if (SpectralAngleMapperDescriptor.this.showRulesImagesParameter.getValueBool()) {
                List<RuleImageParameter.RuleImageRecord> list2 = SpectralAngleMapperDescriptor.this.showRulesImagesParameter.getRuleImageRecords();
                for (int i = 0; i < list.size(); ++i) {
                    object = list.get(i);
                    if (!((BreezeIntervalClass)object).isIncluded() || !RuleImageParameter.RuleImageRecord.isIncluded(list2, ((Reference)object).getName())) continue;
                    PropertyFactor propertyFactor = new PropertyFactor("Rule: " + ((Reference)object).getName(), "SamValue_" + i + "_" + StringHelper.removeAllNonXmlTagCharacters(((Reference)object).getName()), "");
                    propertyFactor.setMax(1.0f);
                    rtAnalyse.getPropertyFactors().add(propertyFactor);
                }
            }
            return rtAnalyse;
        }

        @Override
        public RtModelParameters.RtModel createRtModel(Workflow workflow, boolean bl) {
            RtModelParameters.RtModel rtModel = super.createRtModel(workflow, bl);
            if (SpectralAngleMapperDescriptor.this.showRulesImagesParameter.getValueBool()) {
                rtModel.getModule("Base").add(new RtModelParameters.RtParameterScalar("ruleImages", 1.0));
            }
            return rtModel;
        }

        @Override
        protected int getParameterHashCode(FunctionTreeNode functionTreeNode) {
            int n = super.getParameterHashCode(functionTreeNode);
            return n += FunctionParameter.hashCode(SpectralAngleMapperDescriptor.this.showRulesImagesParameter, SpectralAngleMapperDescriptor.this.thresholdParameter, SpectralAngleMapperDescriptor.this.transformationParameter);
        }

        @Override
        protected void addParameters(RtModelParameters.RtModuleSetup rtModuleSetup) {
            super.addParameters(rtModuleSetup);
            double d = SpectralAngleMapperDescriptor.this.thresholdParameter.getValue();
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("threshold", d > 0.0 ? d : Math.PI));
        }

        @Override
        protected String getName() {
            return "Sam";
        }
    };
    private final NumberParameter thresholdParameter;
    private final RuleImageParameter showRulesImagesParameter;
    private final TransformationParameter transformationParameter;

    public SpectralAngleMapperDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.membersSetting.getRangeParameter().setAlias("Regions");
        this.membersSetting.getRangeParameter().setUsage("Eg: 460:980;1200:1800 or empty = all");
        this.thresholdParameter = new NumberParameter("threshold", "Threshold", 0.1, "Note. 0 = no threshold");
        this.addParameter(this.thresholdParameter);
        this.addParameter(new TextParameter("weight", "Weights", "1", "Factor weights from border (ex 1;2;5)"));
        this.transformationParameter = new TransformationParameter();
        this.addParameter(this.transformationParameter);
        this.showRulesImagesParameter = new RuleImageParameter(this, "Output rule images", "One image for each class", false);
        this.addParameter(this.showRulesImagesParameter);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.addOutput("type");
    }

    @Override
    public RtAnalyse getAnalyse() {
        return this.membersSetting.getOrCreateAnalyse(this.getNode());
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    @Override
    public Factor getFactor(int n) {
        RtAnalyse rtAnalyse = this.getAnalyse();
        if (n == 0) {
            return rtAnalyse.getCategoryFactor();
        }
        PropertyList propertyList = rtAnalyse.getPropertyFactors();
        if (!propertyList.isEmpty()) {
            return propertyList.get(0);
        }
        return null;
    }

    @Override
    public boolean hasResult(int n) {
        return n == 0;
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (n == 0) {
            return "Type";
        }
        return "Value";
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        if (n == 0) {
            return ThumbnailDescriptor.ThumbType.ThumbClassification;
        }
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor;
        Object object = this.getFactor(n);
        if (object instanceof CategoryFactor && (object = (categoryFactor = (CategoryFactor)object).getClassByValueIdx((int)f)) != null) {
            return ((CatClass)object).getName();
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public boolean renderCellAt(int n) {
        return n == 0;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        Factor factor = this.getFactor(n3);
        if (factor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        if (functionResult.getIndex() == 0) {
            return new CustomRenderingDescriptor.RenderData(string, Optional.of(FunctionResult.getCategoryColorHexString(functionResult)));
        }
        return new CustomRenderingDescriptor.RenderData(string);
    }

    @Override
    public List<AdditionalFactor> getAdditionalFactors() {
        PropertyList propertyList = this.getAnalyse().getPropertyFactors();
        if (!propertyList.isEmpty()) {
            ArrayList<AdditionalFactor> arrayList = new ArrayList<AdditionalFactor>();
            for (int i = 0; i < propertyList.size(); ++i) {
                arrayList.add(new AdditionalFactor(propertyList.get(i)));
            }
            return arrayList;
        }
        return null;
    }

    @Generated
    public MembersSetting getMembersSetting() {
        return this.membersSetting;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "angle";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new SpectralAngleMapperDescriptor(this);
        }

        public String toString() {
            return "SamDescriptor";
        }

        @Override
        public String getDescription() {
            return "Spectral angle mapper (SAM) classification";
        }

        @Override
        public String getShortDescription() {
            return "Spectral angle mapper";
        }

        @Override
        public String getHelp() {
            return "spectral-angle-mapper-sam-classification";
        }
    }
}

