/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.function;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.entry.workflow.BasicWorkflow;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ExpressionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.polynom.RtPolyNode;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.workflow.Workflow;

public class FunctionDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor {
    private final String version = "1";
    protected PreDefinedExpressionParameter preDefinedParameter;
    protected FunctionExpressionParameter parameter = new FunctionExpressionParameter();
    private final ObjectOrPixelsParameter typeParameter;
    private final WorkflowAnalyseParameter analyseParameter;
    private final PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;
    private final NumberParameter minParameter;
    private final NumberParameter maxParameter;

    public FunctionDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.preDefinedParameter = new PreDefinedExpressionParameter(this.parameter);
        this.addParameter(this.preDefinedParameter);
        this.addParameter(this.parameter);
        this.typeParameter = new ObjectOrPixelsParameter("Apply on object or pixels", this.getDefaultObjectOrPixels());
        this.addParameter(this.typeParameter);
        MinMax minMax = new MinMax(-2.1474836E9f, 2.1474836E9f);
        this.minParameter = new NumberParameter("min", "Min", 0.0, "Min value for visualisation", minMax);
        this.addParameter(this.minParameter);
        this.maxParameter = new NumberParameter("max", "Max", this.getMaxValue(), "Max value for visualisation", minMax);
        this.addParameter(this.maxParameter);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.addOutput("value");
    }

    protected String getDefaultObjectOrPixels() {
        return "object";
    }

    protected int getMaxValue() {
        return 100;
    }

    private int getParameterHashCode(FunctionTreeNode functionTreeNode) {
        int n = 0;
        Workflow workflow = Workflow.getWorkflow(functionTreeNode);
        if (workflow != null) {
            n += StringHelper.hashCode(workflow.getStudyId());
        }
        n += FunctionParameter.hashCode(this.parameter);
        return n += StringHelper.hashCode(this.getAnalyseName());
    }

    private RtAnalyse getOrCreateAnalyse(FunctionTreeNode functionTreeNode) {
        String string = this.getAnalyseName();
        RtAnalyse rtAnalyse = MembersSetting.createAnalyse(functionTreeNode, "Exp" + this.getParameterHashCode(functionTreeNode), this.analyseParameter, string2 -> {
            RtAnalyse rtAnalyse = new RtAnalyse(string2, string, BasicAnalyse.ModelMethod.QuantificationExpression, this.getStudyId(), "1");
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(new RtModelParameters.RtModel(string));
            rtAnalyse.setModelParameters(rtModelParameters);
            rtAnalyse.getPropertyFactors().add(new PropertyFactor(string, string2, ""){

                @Override
                public void setMinMax(MinMax minMax) {
                    super.setMinMax(minMax);
                    if (minMax != null) {
                        FunctionDescriptor.this.minParameter.setValue(minMax.min());
                        FunctionDescriptor.this.maxParameter.setValue(minMax.max());
                    }
                }

                @Override
                public void setMin(float f) {
                    super.setMin(f);
                    FunctionDescriptor.this.minParameter.setValue(f);
                }

                @Override
                public void setMax(float f) {
                    super.setMax(f);
                    FunctionDescriptor.this.maxParameter.setValue(f);
                }
            });
            return rtAnalyse;
        });
        if (rtAnalyse != null) {
            PropertyFactor propertyFactor = rtAnalyse.getPropertyFactors().get(0);
            propertyFactor.setMin(this.minParameter.getValueFloat());
            propertyFactor.setMax(this.maxParameter.getValueFloat());
            propertyFactor.setName(this.getAliasOrAnalyseName());
        }
        return rtAnalyse;
    }

    private String getAliasOrAnalyseName() {
        String string = this.getNode().getAlias();
        if (string != null) {
            return string;
        }
        return this.getAnalyseName();
    }

    protected String getAnalyseName() {
        return "Expression";
    }

    @Override
    public boolean hasThumbnail(int n) {
        return !this.typeParameter.isObject();
    }

    @Override
    public boolean childDescriptorsAreInput() {
        return true;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        return super.getStringValue(f, n, n2);
    }

    public FunctionExpressionParameter getExpression() {
        return this.parameter;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        String string;
        String string2 = this.preDefinedParameter.getValueStr();
        if (string2.length() > 0) {
            return string2;
        }
        List list = this.parameter.getExpressionLists();
        if (list.size() == 1 && (string = ((FunctionExpression)list.get(0)).getExpression()) != null && string.length() > 0) {
            return string;
        }
        return this.getDefaultName();
    }

    protected String getDefaultName() {
        return "Function";
    }

    @Override
    public RtAnalyse getAnalyse() {
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(this.getNode());
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getPropertyFactors().get(0);
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    public static class FunctionExpressionParameter
    extends ExpressionParameter<FunctionExpression> {
        private FunctionExpression functionExpression = new FunctionExpression();

        public FunctionExpressionParameter() {
            super("Expression", "id", "Example: (property1 + property2) * property3");
            this.add(this.functionExpression);
        }

        public void set(String string) {
            this.functionExpression.set(string);
        }

        @Override
        protected FunctionExpression createList(Node node) {
            this.functionExpression = new FunctionExpression(node);
            return this.functionExpression;
        }

        @Override
        public void copy(FunctionParameter functionParameter) {
            super.copy(functionParameter);
            this.functionExpression = (FunctionExpression)this.getExpressionLists().get(0);
        }
    }

    public static class PreDefinedExpressionParameter
    extends TextParameter {
        private final List<PreDefinedExpression> options = new ArrayList<PreDefinedExpression>();
        private final FunctionExpressionParameter expressionParameter;

        public PreDefinedExpressionParameter(FunctionExpressionParameter functionExpressionParameter) {
            super("predefined", "Name", "", "");
            this.expressionParameter = functionExpressionParameter;
        }

        public void add(String string, String string2) {
            this.options.add(new PreDefinedExpression(string, string2));
        }

        @Override
        public boolean setValue(Object object) {
            for (PreDefinedExpression preDefinedExpression : this.options) {
                if (!preDefinedExpression.name.equals(object)) continue;
                this.expressionParameter.setValueStr(preDefinedExpression.expression);
                this.expressionParameter.functionExpression.set(preDefinedExpression.expression);
                break;
            }
            return super.setValue(object);
        }

        @Override
        public boolean isVisible(FunctionTreeNode functionTreeNode) {
            return this.options.size() > 0;
        }

        public List<PreDefinedExpression> getOptions() {
            return this.options;
        }

        @Override
        public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
            Object[] objectArray = new String[this.options.size()];
            for (int i = 0; i < this.options.size(); ++i) {
                objectArray[i] = this.options.get((int)i).name;
            }
            return objectArray;
        }
    }

    public static class ObjectOrPixelsParameter
    extends TextParameter {
        public ObjectOrPixelsParameter(String string) {
            this(string, "object");
        }

        public ObjectOrPixelsParameter(String string, String string2) {
            super("type", "Type", string2, string);
        }

        public boolean isObject() {
            return !this.getValueStr().equalsIgnoreCase("Pixels");
        }

        @Override
        public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
            return new String[]{"Object", "Pixels"};
        }
    }

    public static class FunctionExpression
    extends ExpressionParameter.Expression<Float> {
        private List<SamplePolyNode> polyNodes = new ArrayList<SamplePolyNode>();

        public FunctionExpression() {
        }

        public void prepare(BasicWorkflow basicWorkflow, FunctionTreeNode functionTreeNode) {
            this.polyNodes.clear();
            for (Factor factorOrDescriptor : basicWorkflow.getCategoryFactors()) {
                this.polyNodes.add(new FactorPolyNode(factorOrDescriptor));
            }
            for (Factor factor : basicWorkflow.getPropertyFactors()) {
                this.polyNodes.add(new FactorPolyNode(factor));
            }
            for (DescriptorTreeNode descriptorTreeNode : functionTreeNode.getParent().getDescriptorNodes(false)) {
                if (!descriptorTreeNode.getFunction().isDescriptor() || descriptorTreeNode == functionTreeNode) continue;
                this.polyNodes.add(new DescriptorPolyNode(descriptorTreeNode));
            }
        }

        public FunctionExpression(Node node) {
            super(node);
        }

        public FunctionExpression clone(FunctionParameter functionParameter) {
            FunctionExpression functionExpression = (FunctionExpression)super.clone(functionParameter);
            functionExpression.polyNodes = new ArrayList<SamplePolyNode>();
            return functionExpression;
        }

        private static class FactorPolyNode
        extends RtPolyNode
        implements SamplePolyNode {
            private final Factor factor;

            public FactorPolyNode(Factor factor) {
                super(StringHelper.removeSpace(factor.getName()).toUpperCase());
                this.factor = factor;
            }

            @Override
            public void setValue(BasicSample basicSample) {
                Float f = basicSample.getSampleValues().getValue(this.factor);
                this.setNum(f != null ? f.floatValue() : 0.0f);
            }
        }

        private static class DescriptorPolyNode
        extends RtPolyNode
        implements SamplePolyNode {
            private final DescriptorTreeNode node;

            public DescriptorPolyNode(DescriptorTreeNode descriptorTreeNode) {
                super(StringHelper.removeSpace(descriptorTreeNode.getAliasOrNodeString().toUpperCase()));
                this.node = descriptorTreeNode;
            }

            @Override
            public void setValue(BasicSample basicSample) {
                Float f = Float.valueOf(basicSample.getDescriptorValue(this.node));
                this.setNum(f != null ? f.floatValue() : 0.0f);
            }
        }

        private static interface SamplePolyNode {
            public void setValue(BasicSample var1);
        }
    }

    public static class PreDefinedExpression {
        private final String name;
        private final String expression;

        public PreDefinedExpression(String string, String string2) {
            this.name = string;
            this.expression = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "combine";
        }

        @Override
        public FunctionDescriptor createFunction() {
            return new FunctionDescriptor(this);
        }

        public String toString() {
            return "Function";
        }

        @Override
        public String getDescription() {
            return "Combine properties, categories and descriptors using expression";
        }

        @Override
        public String getShortDescription() {
            return "Combine properties";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Expression;
        }

        @Override
        public String getHelp() {
            return "combine-properties-categories-and-descriptors-usin";
        }
    }
}

