/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.function;

import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PcaQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.PropertyFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.breeze.entry.measurement.Measurement;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.Thumbnail;
import se.prediktera.breeze.frontend.common.swing.table.thumbnail.ThumbnailPackedRgb;

public class RgbDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor {
    private final String version = "1";
    private PropertyFactorParameter redParameter;
    private PropertyFactorParameter greenParameter;
    private PropertyFactorParameter blueParameter;
    private final PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;
    private WorkflowAnalyseParameter analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());

    public RgbDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.redParameter = new PropertyFactorParameter("idRed", "Red", 0);
        this.addParameter(this.redParameter);
        this.greenParameter = new PropertyFactorParameter("idGreen", "Green", 1);
        this.addParameter(this.greenParameter);
        this.blueParameter = new PropertyFactorParameter("idBlue", "Blue", 2);
        this.addParameter(this.blueParameter);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.addOutput("value");
    }

    public PropertyFactorParameter.NodePropertyAnalyse[] getPropertyAnalyses() {
        return new PropertyFactorParameter.NodePropertyAnalyse[]{this.redParameter.getNodePropertyAnalyse(this.getNode()), this.greenParameter.getNodePropertyAnalyse(this.getNode()), this.blueParameter.getNodePropertyAnalyse(this.getNode())};
    }

    @Override
    public RtAnalyse getAnalyse() {
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(this.getNode());
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getPropertyFactors().get(0);
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbPackedRgb;
    }

    @Override
    public boolean hasResult(int n) {
        return false;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        return super.getStringValue(f, n, n2);
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Pseudo RGB";
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    private int getParameterHashCode(String string) {
        int n = StringHelper.hashCode(string);
        return n += FunctionParameter.hashCode(this.redParameter, this.greenParameter, this.blueParameter, this.smoothParameter);
    }

    public RtAnalyse getOrCreateAnalyse(final FunctionTreeNodeWithId functionTreeNodeWithId) {
        String string = this.getStudyId();
        RtAnalyse rtAnalyse = MembersSetting.createAnalyse(functionTreeNodeWithId, "PseudoRgb_" + this.getParameterHashCode(string), this.analyseParameter, new MembersSetting.CreateAnalyseCallback(){
            final /* synthetic */ RgbDescriptor this$0;
            {
                this.this$0 = rgbDescriptor;
            }

            @Override
            public RtAnalyse create(String string) {
                RtAnalyse rtAnalyse = new RtAnalyse(string, "PseudoRgb", BasicAnalyse.ModelMethod.QuantificationRgb, this.this$0.getStudyId(), "1");
                rtAnalyse.getPropertyFactors().add(new PropertyFactorPackedRgb("PseudoRgb", string));
                rtAnalyse.setObjectMethod(this);
                return rtAnalyse;
            }

            @Override
            public void deferredCreate(RtAnalyse rtAnalyse) {
                RtModelParameters rtModelParameters = new RtModelParameters();
                rtModelParameters.addModel(this.this$0.createRtModel(functionTreeNodeWithId));
                rtAnalyse.setModelParameters(rtModelParameters);
            }
        });
        rtAnalyse.getPropertyFactors().get(0).setName(functionTreeNodeWithId.getAliasOrNodeString());
        return rtAnalyse;
    }

    public RtModelParameters.RtModel createRtModel(FunctionTreeNode functionTreeNode) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("PseudoRgb");
        RtModelParameters.RtModuleSetupList rtModuleSetupList = rtModel.getModules();
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        RgbDescriptor.addAnalyse(rtModuleSetup, functionTreeNode, this.redParameter, 1);
        RgbDescriptor.addAnalyse(rtModuleSetup, functionTreeNode, this.greenParameter, 2);
        RgbDescriptor.addAnalyse(rtModuleSetup, functionTreeNode, this.blueParameter, 3);
        rtModuleSetupList.add(rtModuleSetup);
        return rtModel;
    }

    private static void addAnalyse(RtModelParameters.RtModuleSetup rtModuleSetup, FunctionTreeNode functionTreeNode, PropertyFactorParameter propertyFactorParameter, int n) {
        PropertyFactorParameter.NodePropertyAnalyse nodePropertyAnalyse = propertyFactorParameter.getNodePropertyAnalyse(functionTreeNode);
        if (nodePropertyAnalyse != null) {
            BasicAnalyse basicAnalyse = nodePropertyAnalyse.analyse();
            rtModuleSetup.add(new RtModelParameters.RtParameterString("analyse" + n, basicAnalyse.getUid()));
            PropertyFactor propertyFactor = nodePropertyAnalyse.factor();
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("index" + n, nodePropertyAnalyse.getFactorIndex()));
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("min" + n, propertyFactor.getMin()));
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("max" + n, propertyFactor.getMax()));
            rtModuleSetup.add(new RtModelParameters.RtParameterScalar("postApply" + n, nodePropertyAnalyse.node().getFunction() instanceof PcaQuantificationDescriptor ? 1.0 : 0.0));
        }
    }

    public static class PropertyFactorPackedRgb
    extends PropertyFactor {
        public PropertyFactorPackedRgb(String string, String string2) {
            super(string, string2, "");
        }

        @Override
        public Thumbnail createThumbnail(Measurement measurement, Sample sample, AbstractBreezeFunction abstractBreezeFunction, BasicAnalyse basicAnalyse, boolean bl, boolean bl2) {
            return new ThumbnailPackedRgb(measurement, sample, basicAnalyse, abstractBreezeFunction, this, bl, bl2);
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "combine_rgb";
        }

        @Override
        public RgbDescriptor createFunction() {
            return new RgbDescriptor(this);
        }

        public String toString() {
            return "Rgb";
        }

        @Override
        public String getDescription() {
            return "Combine properties into pseudo rgb image";
        }

        @Override
        public String getShortDescription() {
            return "Combined RGB image";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Spatial;
        }

        @Override
        public String getHelp() {
            return "combine-rgb-image";
        }
    }
}

