/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.function;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.ClassParameterDescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationAreaDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ClassParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.descriptor.spectralLibraries.GroupCatClass;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;

public class TernaryRgbDescriptor
extends AbstractDescriptor
implements ClassParameterDescriptorInterface,
ThumbnailDescriptor {
    private final String version = "1";
    private final HashMap<Integer, Color> classToColor = new HashMap<Integer, Color>(){
        {
            this.put(7, Color.white);
            this.put(6, Color.yellow);
            this.put(5, Color.magenta);
            this.put(4, Color.cyan);
            this.put(3, Color.red);
            this.put(2, Color.green);
            this.put(1, Color.blue);
            this.put(0, Color.black);
        }
    };
    private final ClassParameter classParameter1;
    private final ClassParameter classParameter2;
    private final ClassParameter classParameter3;
    private final IDParameter.IDClassifcationParameter idParameter1 = new IDParameter.IDClassifcationParameter("id1", "Classification descriptor R", null);
    private final IDParameter.IDClassifcationParameter idParameter2;
    private final IDParameter.IDClassifcationParameter idParameter3;
    private final WorkflowAnalyseParameter analyseParameter;

    public AddParameter.AddNodeList getAddNodes() {
        AddParameter.AddNodeList addNodeList = new AddParameter.AddNodeList();
        CategoryFactor categoryFactor = (CategoryFactor)this.getFactor(0);
        for (CatClass catClass : categoryFactor.getGroupedClasses()) {
            if (catClass.isNoClass()) continue;
            DescriptorTreeNode descriptorTreeNode = new DescriptorTreeNode();
            descriptorTreeNode.setAlias(catClass.getName());
            PlsPredClassificationAreaDescriptor plsPredClassificationAreaDescriptor = (PlsPredClassificationAreaDescriptor)this.clone();
            plsPredClassificationAreaDescriptor.getClassParameter().setValue(catClass);
            descriptorTreeNode.setFunction(plsPredClassificationAreaDescriptor);
            addNodeList.add(new AddParameter.AddNode(descriptorTreeNode, this.getNode()));
        }
        return addNodeList;
    }

    public TernaryRgbDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addParameter(this.idParameter1);
        this.classParameter1 = new ClassParameter("class_red", "id", "Red", this.idParameter1);
        this.addParameter(this.classParameter1);
        this.idParameter2 = new IDParameter.IDClassifcationParameter("id2", "Classification descriptor G", null);
        this.addParameter(this.idParameter2);
        this.classParameter2 = new ClassParameter("class_green", "id", "Green", this.idParameter2);
        this.addParameter(this.classParameter2);
        this.idParameter3 = new IDParameter.IDClassifcationParameter("id3", "Classification descriptor B", null);
        this.addParameter(this.idParameter3);
        this.classParameter3 = new ClassParameter("class_blue", "id", "Blue", this.idParameter3);
        this.addParameter(this.classParameter3);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.addOutput("value");
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        Factor factor = this.getFactor(this.getNode().getIndex());
        if (n == 0 && factor instanceof CategoryFactor) {
            CatClass catClass;
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            int n3 = (int)f;
            if (n3 >= 0 && n3 < categoryFactor.getClassCount() && (catClass = categoryFactor.getClassByValueIdx(n3)) != null) {
                return catClass.getName();
            }
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "RGB";
    }

    @Override
    public CategoryFactor getCategoryFactor(FunctionTreeNode functionTreeNode) {
        return this.getAnalyse().getCategoryFactor();
    }

    @Override
    public RtAnalyse getAnalyse() {
        RtAnalyse rtAnalyse = this.getOrCreateAnalyse(this.getNode());
        this.analyseParameter.setValue(rtAnalyse);
        return rtAnalyse;
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getCategoryFactor();
    }

    private int getParameterHashCode(String string) {
        int n = StringHelper.hashCode(string);
        return n += FunctionParameter.hashCode(this.idParameter1, this.idParameter2, this.idParameter3, this.classParameter1, this.classParameter2, this.classParameter3);
    }

    public RtAnalyse getOrCreateAnalyse(final FunctionTreeNode functionTreeNode) {
        if (BreezeMasterCache.getRtAnalyseListOrNull() == null) {
            return null;
        }
        String string = this.getStudyId();
        return MembersSetting.createAnalyse(functionTreeNode, "TernaryRgb_" + this.getParameterHashCode(string), this.analyseParameter, new MembersSetting.CreateAnalyseCallback(){
            final /* synthetic */ TernaryRgbDescriptor this$0;
            {
                this.this$0 = ternaryRgbDescriptor;
            }

            @Override
            public RtAnalyse create(String string) {
                RtAnalyse rtAnalyse = new RtAnalyse(string, "TernaryRgb", BasicAnalyse.ModelMethod.ClassificationRgb, this.this$0.getStudyId(), "1");
                CategoryFactor categoryFactor = new CategoryFactor("TernaryRgb", "TernaryRgb");
                for (int i = 0; i < 8; ++i) {
                    Color color = this.this$0.classToColor.get(i);
                    CatClass catClass = categoryFactor.addClass(this.this$0.indexToClassName(i), color);
                    catClass.setIndex(i);
                }
                rtAnalyse.getCategoryFactors().add(categoryFactor);
                rtAnalyse.setObjectMethod(this);
                return rtAnalyse;
            }

            @Override
            public void deferredCreate(RtAnalyse rtAnalyse) {
                RtModelParameters rtModelParameters = new RtModelParameters();
                rtModelParameters.addModel(this.this$0.createRtModel(functionTreeNode));
                rtAnalyse.setModelParameters(rtModelParameters);
            }
        });
    }

    private String indexToClassName(int n) {
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("red", this.classParameter1.getValueStr());
        hashMap.put("green", this.classParameter2.getValueStr());
        hashMap.put("blue", this.classParameter3.getValueStr());
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (Object object2 : hashMap.values()) {
            hashMap2.put((String)object2, hashMap2.getOrDefault(object2, 0) + 1);
        }
        HashMap hashMap3 = new HashMap();
        object2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getValue();
            if ((Integer)hashMap2.get(string) > 1) {
                ((HashMap)object2).put(string, ((HashMap)object2).getOrDefault(string, 0) + 1);
                hashMap3.put((String)entry.getKey(), string + "(" + String.valueOf(((HashMap)object2).get(string)) + ")");
                continue;
            }
            hashMap3.put((String)entry.getKey(), string);
        }
        return switch (n) {
            case 1 -> (String)hashMap3.get("blue");
            case 2 -> (String)hashMap3.get("green");
            case 3 -> (String)hashMap3.get("red");
            case 4 -> (String)hashMap3.get("blue") + "," + (String)hashMap3.get("green");
            case 5 -> (String)hashMap3.get("red") + "," + (String)hashMap3.get("blue");
            case 6 -> (String)hashMap3.get("green") + "," + (String)hashMap3.get("red");
            case 7 -> "All";
            default -> "None";
        };
    }

    public RtModelParameters.RtModel createRtModel(FunctionTreeNode functionTreeNode) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("TernaryRgb");
        RtModelParameters.RtModuleSetupList rtModuleSetupList = rtModel.getModules();
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        rtModuleSetup.add(new RtModelParameters.RtParameterString("analyseUid1", this.idParameter1.getAnalyse(functionTreeNode) != null && this.idParameter1.getAnalyse(functionTreeNode).getUid() != null ? this.idParameter1.getAnalyse(functionTreeNode).getUid() : this.idParameter1.getText()));
        rtModuleSetup.add(new RtModelParameters.RtParameterVector("class1ids", this.getClassIndexes(functionTreeNode, this.classParameter1)));
        rtModuleSetup.add(new RtModelParameters.RtParameterString("analyseUid2", this.idParameter2.getAnalyse(functionTreeNode) != null && this.idParameter2.getAnalyse(functionTreeNode).getUid() != null ? this.idParameter2.getAnalyse(functionTreeNode).getUid() : this.idParameter2.getText()));
        rtModuleSetup.add(new RtModelParameters.RtParameterVector("class2ids", this.getClassIndexes(functionTreeNode, this.classParameter2)));
        rtModuleSetup.add(new RtModelParameters.RtParameterString("analyseUid3", this.idParameter3.getAnalyse(functionTreeNode) != null && this.idParameter3.getAnalyse(functionTreeNode).getUid() != null ? this.idParameter3.getAnalyse(functionTreeNode).getUid() : this.idParameter3.getText()));
        rtModuleSetup.add(new RtModelParameters.RtParameterVector("class3ids", this.getClassIndexes(functionTreeNode, this.classParameter3)));
        rtModuleSetupList.add(rtModuleSetup);
        return rtModel;
    }

    public int[] getClassIndexes(FunctionTreeNode functionTreeNode, ClassParameter classParameter) {
        try {
            CatClass catClass = classParameter.getCatClass(functionTreeNode);
            if (catClass instanceof GroupCatClass) {
                GroupCatClass groupCatClass = (GroupCatClass)catClass;
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (CatClass catClass2 : groupCatClass.getFactor().getClasses()) {
                    if (!groupCatClass.isSameGroup(catClass2)) continue;
                    arrayList.add(catClass2.getValueIdx());
                }
                return arrayList.stream().mapToInt(n -> n).toArray();
            }
            return new int[]{catClass.getValueIdx()};
        }
        catch (NullPointerException nullPointerException) {
            return new int[]{0};
        }
    }

    @Override
    public boolean hasResult(int n) {
        return false;
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbClassification;
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "rgb_venn";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new TernaryRgbDescriptor(this);
        }

        public String toString() {
            return "TernaryRgbDescriptor";
        }

        @Override
        public String getDescription() {
            return "Combine three classifications to single rgb image";
        }

        @Override
        public String getShortDescription() {
            return "Ternary RGB";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Classification;
        }

        @Override
        public String getHelp() {
            return "na";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("rgb", "classification", "realtime");
        }
    }
}

