/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.map.register.RegInfo;

public class ClusterClassificationDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor {
    private final String version = "1";
    private WorkflowAnalyseParameter analyseParameter;
    private NumberParameter clusterParameter = new NumberParameter("cluster", "Number of cluster", 3.0, "");
    private ModelParameter modelParameter;
    private TransformationParameter transformationParameter;

    public ClusterClassificationDescriptor(Info info) {
        super(info);
        this.addParameter(this.clusterParameter);
        this.modelParameter = new ModelParameter();
        this.addParameter(this.modelParameter);
        this.transformationParameter = new TransformationParameter();
        this.addParameter(this.transformationParameter);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
    }

    @Override
    public RtAnalyse getAnalyse() {
        return this.getOrCreateAnalyse(this.getNode());
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getCategoryFactor();
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    private int getParameterHashCode(String string) {
        int n = StringHelper.hashCode(string);
        return n += FunctionParameter.hashCode(this.clusterParameter, this.modelParameter, this.transformationParameter);
    }

    public RtAnalyse getOrCreateAnalyse(FunctionTreeNode functionTreeNode) {
        String string = this.getStudyId();
        return MembersSetting.createAnalyse(functionTreeNode, "Cluster_" + this.getParameterHashCode(string), this.analyseParameter, string2 -> {
            RtAnalyse rtAnalyse = new RtAnalyse(string2, "Cluster", BasicAnalyse.ModelMethod.ClassificationCluster, string, "1");
            CategoryFactor categoryFactor = CategoryFactor.withNoClass("Cluster", "Cluster");
            for (int i = 0; i < this.clusterParameter.getValueInt(); ++i) {
                categoryFactor.addClass(String.valueOf((char)(65 + i)));
            }
            rtAnalyse.getCategoryFactors().add(categoryFactor);
            rtAnalyse.setObjectMethod(this);
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(this.createRtModel(false));
            rtAnalyse.setModelParameters(rtModelParameters);
            return rtAnalyse;
        });
    }

    public RtModelParameters.RtModel createRtModel(boolean bl) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("Cluster");
        RtModelParameters.RtModuleSetupList rtModuleSetupList = rtModel.getModules();
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("cluster", this.clusterParameter.getValueInt()));
        rtModuleSetupList.add(rtModuleSetup);
        return rtModel;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        return "Clustering";
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbClassification;
    }

    @Override
    public boolean hasResult(int n) {
        return false;
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    public static class ModelParameter
    extends OptionParameter {
        public ModelParameter() {
            super("model", "Model", "k-means", "Which clustering model to use");
            this.add(new OptionParameter.Option("k-means", "K-Means"));
            this.add(new OptionParameter.Option("gmm", "Gaussian Mixture Mode"));
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "cluster";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new ClusterClassificationDescriptor(this);
        }

        public String toString() {
            return "ClusterClassification";
        }

        @Override
        public String getShortDescription() {
            return "Clustering";
        }

        @Override
        public String getDescription() {
            return "Unsupervised cluster classification descriptor";
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Record;
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return RegInfo.isRecordFeature() && !RegInfo.isApplicationFeature() ? AbstractCardInfo.GroupType.Recorder : AbstractCardInfo.GroupType.Model;
        }

        @Override
        public String getHelp() {
            return "clustering";
        }
    }
}

