/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.util.Arrays;
import java.util.List;
import no.uib.cipr.matrix.DenseMatrix;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseFactorClassParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.map.common.progress.ProgressManager;
import se.prediktera.map.datasetcontainer.datainfo.InnerColumnString;
import se.prediktera.map.datasetcontainer.matrix.MatrixContainer;
import se.prediktera.map.model.AbstractModel;

public class ModelDataDescriptor
extends AbstractModelDescriptor {
    private ModelDataParameter modelDataParameter;
    private AnalyseFactorClassParameter classParamter = new AnalyseFactorClassParameter("class", this);

    public ModelDataDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.classParamter);
        this.classParamter.setVisible(() -> this.getFactor(0) instanceof CategoryFactor);
        this.modelDataParameter = new ModelDataParameter();
        this.addParameter(this.modelDataParameter);
        this.addOutput("value");
    }

    @Override
    public List<BasicAnalyse.ModelType> getModelTypes() {
        return Arrays.asList(BasicAnalyse.ModelType.Quantification, BasicAnalyse.ModelType.Classification);
    }

    @Override
    public BasicAnalyse.ModelType getModelType() {
        return null;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        CatClass catClass;
        String string = ((OptionParameter.Option)this.modelDataParameter.getValueObj()).toString();
        Factor factor = this.getFactor(0);
        if (factor instanceof CategoryFactor && (catClass = this.classParamter.getCatClass()) != null) {
            return string + " (" + catClass.getName() + ")";
        }
        if (factor != null) {
            return string + " (" + factor.getName() + ")";
        }
        return string;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        if (Float.isNaN(f)) {
            return "";
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public List<AdditionalFactor> getAdditionalFactors() {
        return super.getAdditionalFactors();
    }

    public static class ModelDataParameter
    extends OptionParameter {
        public ModelDataParameter() {
            super("data", "Data", "ycalc", "");
            this.add(new OptionParameter.Option("ycalc", "Ycalc"));
            this.add(new OptionParameter.Option("ycalccv", "Ycalc CV"));
        }
    }

    public static class ModelDataFunctionResult
    extends FunctionResult {
        private final BasicSample sample;

        public ModelDataFunctionResult(DescriptorTreeNode descriptorTreeNode, Sample sample) {
            super(descriptorTreeNode);
            this.sample = sample;
            this.setValue(0.0f);
        }

        public ModelDataFunctionResult(DescriptorTreeNode descriptorTreeNode, Node node, Sample sample) {
            super(descriptorTreeNode, node);
            this.sample = sample;
        }

        @Override
        public String getStringValueWithUnit() {
            if (Float.isNaN(this.value)) {
                return "";
            }
            return super.getStringValueWithUnit();
        }

        @Override
        public float getValue() {
            BasicAnalyse basicAnalyse = this.getAnalyse();
            if (basicAnalyse instanceof Analyse) {
                Analyse analyse = (Analyse)basicAnalyse;
                ModelDataDescriptor modelDataDescriptor = (ModelDataDescriptor)this.getNode().getFunction();
                AbstractModel abstractModel = analyse.getBaseModel((ProgressManager)ProgressManager.createEmpty());
                List<Integer> list = analyse.sampleIndex(this.sample).train();
                int n = list.size();
                if (n > 0) {
                    String string = modelDataDescriptor.modelDataParameter.getValueStr();
                    int n2 = this.getVariable(analyse, modelDataDescriptor.getFactor(0), modelDataDescriptor.classParamter.getCatClass());
                    MatrixContainer matrixContainer = (MatrixContainer)abstractModel.getMatrixByName(string);
                    if (matrixContainer != null) {
                        String string2 = this.sample.measurement().getName();
                        InnerColumnString innerColumnString = (InnerColumnString)matrixContainer.getRowDescription().getInnerColumnByName("Measurement");
                        if (innerColumnString != null) {
                            for (int i = 0; i < innerColumnString.getSize(); ++i) {
                                if (!innerColumnString.getValue(i).equals(string2)) continue;
                                DenseMatrix denseMatrix = matrixContainer.getLastMatrix();
                                if (denseMatrix != null) {
                                    float f = 0.0f;
                                    int n3 = 0;
                                    for (int j = 0; j < n; ++j) {
                                        int n4 = i + list.get(j);
                                        int n5 = matrixContainer.getNrefOrig(n4);
                                        if (n5 < 0 || n5 >= denseMatrix.numRows()) continue;
                                        f += (float)denseMatrix.get(n5, n2);
                                        ++n3;
                                    }
                                    if (n3 > 0) {
                                        return f / (float)n3;
                                    }
                                }
                                return Float.NaN;
                            }
                        }
                    }
                }
            }
            return Float.NaN;
        }

        private int getVariable(Analyse analyse, Factor factor, CatClass catClass) {
            if (factor instanceof CategoryFactor) {
                CategoryFactor categoryFactor = (CategoryFactor)factor;
                return categoryFactor.getRealClasses().indexOf(catClass);
            }
            return analyse.getPropertyFactors().indexOf(factor);
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "modeldata";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new ModelDataDescriptor(this);
        }

        public String toString() {
            return "ModelData";
        }

        @Override
        public String getDescription() {
            return "Model data (Ycalc, Ycalc CV)";
        }

        @Override
        public String getHelp() {
            return "model-data";
        }
    }
}

