/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredQuantificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TransformationParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.WorkflowAnalyseParameter;
import se.prediktera.breeze.common.realtime.unmixing.MembersSetting;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.analyse.model.ModelProperties;
import se.prediktera.breeze.entry.cache.BreezeMasterCache;
import se.prediktera.map.register.RegInfo;
import se.prediktera.map.register.RegisterKeyManager;

public class PcaQuantificationDescriptor
extends AbstractDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor {
    private final String version = "1";
    private final PlsPredQuantificationDescriptor.SmoothParameter smoothParameter;
    private final WorkflowAnalyseParameter analyseParameter;
    private final NumberParameter numComponentsParameter = new NumberParameter("components", "Number of components", 3.0, "");
    private final TransformationParameter transformationParameter;

    public PcaQuantificationDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        this.addParameter(this.numComponentsParameter);
        if (RegisterKeyManager.usingPredikteraDevelopmentLicense()) {
            this.addParameter(new NumberParameter("maxPoints", "Max training points", 0.0, ""));
        }
        this.transformationParameter = new TransformationParameter();
        this.addParameter(this.transformationParameter);
        this.analyseParameter = new WorkflowAnalyseParameter("analyse", BreezeMasterCache.getRtAnalyseListOrNull());
        this.addParameter(this.analyseParameter);
        this.analyseParameter.setVisible(false);
        this.smoothParameter = new PlsPredQuantificationDescriptor.SmoothParameter();
        this.addParameter(this.smoothParameter);
    }

    @Override
    public RtAnalyse getAnalyse() {
        return this.getOrCreateAnalyse(this.getNode());
    }

    @Override
    public Factor getFactor(int n) {
        return this.getAnalyse().getPropertyFactors().get(n);
    }

    @Override
    public List<ModelProperties.TransformationProperties> getTransformations() {
        return this.transformationParameter.getTransformations();
    }

    private int getParameterHashCode(String string) {
        int n = StringHelper.hashCode(string);
        n += FunctionParameter.hashCode(this.numComponentsParameter, this.transformationParameter);
        return n += StringHelper.hashCode(this.getModelMethod().name());
    }

    public RtAnalyse getOrCreateAnalyse(FunctionTreeNode functionTreeNode) {
        String string = this.getStudyId();
        return MembersSetting.createAnalyse(functionTreeNode, "Pca_" + this.getParameterHashCode(string), this.analyseParameter, string2 -> {
            RtAnalyse rtAnalyse = new RtAnalyse(string2, "Pca", this.getModelMethod(), string, "1");
            for (int i = 0; i < this.numComponentsParameter.getValueInt(); ++i) {
                PropertyFactor propertyFactor = new PropertyFactor("PC " + (i + 1), "PcaComponent" + i, "");
                propertyFactor.setMin(-1.0f);
                propertyFactor.setMax(1.0f);
                propertyFactor.setDynamicMinMax(true);
                rtAnalyse.getPropertyFactors().add(propertyFactor);
            }
            rtAnalyse.setObjectMethod(this);
            RtModelParameters rtModelParameters = new RtModelParameters();
            rtModelParameters.addModel(this.createRtModel(false));
            rtAnalyse.setModelParameters(rtModelParameters);
            return rtAnalyse;
        });
    }

    protected BasicAnalyse.ModelMethod getModelMethod() {
        return BasicAnalyse.ModelMethod.QuantificationPca;
    }

    public RtModelParameters.RtModel createRtModel(boolean bl) {
        RtModelParameters.RtModel rtModel = new RtModelParameters.RtModel("Pca");
        RtModelParameters.RtModuleSetupList rtModuleSetupList = rtModel.getModules();
        RtModelParameters.RtModuleSetup rtModuleSetup = new RtModelParameters.RtModuleSetup("Base");
        rtModuleSetup.add(new RtModelParameters.RtParameterScalar("components", this.numComponentsParameter.getValueInt()));
        rtModuleSetupList.add(rtModuleSetup);
        return rtModel;
    }

    @Override
    public List<AdditionalFactor> getAdditionalFactors() {
        PropertyList propertyList;
        RtAnalyse rtAnalyse = this.getAnalyse();
        if (rtAnalyse != null && (propertyList = rtAnalyse.getPropertyFactors()).size() > 1) {
            ArrayList<AdditionalFactor> arrayList = new ArrayList<AdditionalFactor>();
            for (int i = 1; i < propertyList.size(); ++i) {
                AdditionalFactor additionalFactor = new AdditionalFactor(propertyList.get(i));
                additionalFactor.setVisibleInTree(false);
                arrayList.add(additionalFactor);
            }
            return arrayList;
        }
        return null;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (textType.isTable()) {
            return "PC " + (n + 1);
        }
        return "PCA";
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    @Override
    public boolean hasResult(int n) {
        return false;
    }

    @Override
    public boolean hasThumbnail(int n) {
        return true;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "pca";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new PcaQuantificationDescriptor(this);
        }

        public String toString() {
            return "PcaQuantification";
        }

        @Override
        public String getShortDescription() {
            return "PCA model";
        }

        @Override
        public String getDescription() {
            return "Unsupervised pca model descriptor";
        }

        @Override
        public RegInfo.LicenseFeature getLicenseFeature() {
            return RegInfo.LicenseFeature.Record;
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return RegInfo.isRecordFeature() && !RegInfo.isApplicationFeature() ? AbstractCardInfo.GroupType.Recorder : AbstractCardInfo.GroupType.Model;
        }

        @Override
        public String getHelp() {
            return "pca-model";
        }
    }
}

