/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.ClassParameterDescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ClassParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.entry.sample.Sample;
import se.prediktera.breeze.frontend.BreezeMainPanel;
import se.prediktera.breeze.frontend.common.view.ViewContainer;
import se.prediktera.breeze.frontend.common.view.preview.BasicPreviewPanel;
import se.prediktera.breeze.frontend.common.view.preview.ImagePreviewPanel;
import se.prediktera.breeze.frontend.main.play.realtime.LegendPanel;

public class PlsPredClassificationAreaDescriptor
extends AbstractModelDescriptor
implements ClassParameterDescriptorInterface,
CustomRenderingDescriptor,
AddParameter.AddFunctionWithAliasInterface {
    private final ClassParameter classParameter;
    private final BooleanParameter percentParameter;
    private BooleanParameter noClassParameter;
    private BooleanParameter showSummaryParameter;

    public PlsPredClassificationAreaDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.factorParameter.setVisible(true);
        this.classParameter = new ClassParameter("class", "id", "Class", this);
        this.addParameter(this.classParameter);
        this.percentParameter = new BooleanParameter("percent", "Percent", "", false);
        this.addParameter(this.percentParameter);
        this.noClassParameter = new BooleanParameter("noclass", "Include no class", "", false);
        this.addParameter(this.noClassParameter);
        this.noClassParameter.setVisible(this.percentParameter::getValueBool);
        this.addParameter(new BooleanParameter("connected", "Connected", "Max number of connected pixels", false));
        this.showSummaryParameter = new BooleanParameter("summary", "Summary visualization", "Show summary of all child nodes", false);
        this.addParameter(this.showSummaryParameter);
        this.addParameter(new AddParameter(this, "Add child nodes for each class", false, null));
        this.addOutput("value");
    }

    @Override
    public AddParameter.AddNodeList getAddNodes() {
        AddParameter.AddNodeList addNodeList = new AddParameter.AddNodeList();
        CategoryFactor categoryFactor = (CategoryFactor)this.getFactor(0);
        for (CatClass catClass : categoryFactor.getGroupedClasses()) {
            if (catClass.isNoClass()) continue;
            DescriptorTreeNode descriptorTreeNode = new DescriptorTreeNode();
            PlsPredClassificationAreaDescriptor plsPredClassificationAreaDescriptor = (PlsPredClassificationAreaDescriptor)this.clone();
            plsPredClassificationAreaDescriptor.getClassParameter().setValue(catClass);
            descriptorTreeNode.setFunction(plsPredClassificationAreaDescriptor);
            addNodeList.add(new AddParameter.AddNode(descriptorTreeNode, this.getNode()));
        }
        return addNodeList;
    }

    @Override
    public boolean changeHierarchical(FunctionParameter functionParameter) {
        if (functionParameter instanceof ClassParameter) {
            return false;
        }
        return super.changeHierarchical(functionParameter);
    }

    @Override
    public boolean support(AbstractBreezeFunction abstractBreezeFunction) {
        return abstractBreezeFunction instanceof PlsPredClassificationAreaDescriptor;
    }

    @Override
    public BasicAnalyse.ModelType getModelType() {
        return BasicAnalyse.ModelType.Classification;
    }

    @Override
    public Factor getVisualizationFactor(int n) {
        return null;
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        if (this.showSummaryParameter.getValueBool()) {
            return "";
        }
        if (this.percentParameter.getValueBool()) {
            return RtDataFormat.toPercent(f, false);
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public String getUnit(FunctionTreeNode functionTreeNode, int n) {
        if (!this.showSummaryParameter.getValueBool() && this.percentParameter.getValueBool()) {
            return "%";
        }
        return "";
    }

    @Override
    public MinMax getMinMax(int n) {
        if (!this.showSummaryParameter.getValueBool() && this.percentParameter.getValueBool()) {
            return MinMax.Percent;
        }
        return null;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        CategoryFactor categoryFactor;
        CatClass catClass;
        boolean bl = this.percentParameter.getValueBool();
        if (textType.equals((Object)FunctionTreeNode.TextType.Normal)) {
            if (bl) {
                return "Percent of class";
            }
            return "Number of pixels";
        }
        if (textType.equals((Object)FunctionTreeNode.TextType.Table) && this.showSummaryParameter.getValueBool()) {
            return "Summary";
        }
        Factor factor = this.getFactor(n);
        if (factor instanceof CategoryFactor && (catClass = this.getCatClass(categoryFactor = (CategoryFactor)factor)) != null) {
            if (textType.equals((Object)FunctionTreeNode.TextType.Simple)) {
                return catClass.getName();
            }
            String string = this.getRootAlias(functionTreeNode);
            String string2 = string != null ? string : categoryFactor.getName();
            return string2 + " (" + catClass.getName() + ")";
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    public CatClass getCatClass(CategoryFactor categoryFactor) {
        return this.classParameter.getCatClass(categoryFactor);
    }

    @Override
    public CategoryFactor getCategoryFactor(FunctionTreeNode functionTreeNode) {
        Factor factor = this.getFactor(functionTreeNode.getIndex());
        if (factor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            return categoryFactor;
        }
        return null;
    }

    @Override
    public boolean renderCellAt(int n) {
        return true;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        if (this.showSummaryParameter.getValueBool()) {
            boolean bl = this.percentParameter.getValueBool();
            CategoryFactor categoryFactor = (CategoryFactor)this.getFactor(0);
            List<PlsPredClassificationAreaDescriptor> list = PlsPredClassificationAreaDescriptor.getFunctionList(this.getNode());
            int n4 = bl ? 0 : sample.getSamplePath().getArea();
            double d = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                CatClass catClass;
                PlsPredClassificationAreaDescriptor plsPredClassificationAreaDescriptor = list.get(i);
                FunctionTreeNodeWithId functionTreeNodeWithId = plsPredClassificationAreaDescriptor.getNode();
                FunctionResult functionResult = sample.getFunctionResult(functionTreeNodeWithId.getUid());
                double d2 = 0.0;
                if (functionResult != null) {
                    d2 = bl ? (double)functionResult.getValue() : (double)(functionResult.getValue() / (float)n4);
                }
                if ((catClass = plsPredClassificationAreaDescriptor.getCatClass(categoryFactor)) != null) {
                    graphics.setColor(catClass.getColor());
                }
                graphics.fillRect((int)(d * (double)n), 0, (int)Math.ceil(d2 * (double)n), n2);
                d += d2;
            }
        } else {
            CatClass.render(graphics, this.getCatClass(null), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string, Optional.empty(), this.percentParameter.getValueBool());
    }

    @Override
    public boolean isCalculatePixel() {
        return true;
    }

    @Override
    public boolean showInTable() {
        FunctionTreeNode functionTreeNode;
        return !this.showSummaryParameter.getValueBool() || (functionTreeNode = this.getNode().getParent()) == null || !(functionTreeNode.getFunction() instanceof PlsPredClassificationAreaDescriptor);
    }

    @Override
    public boolean isVisible(int n) {
        FunctionTreeNode functionTreeNode = this.getNode().getParent();
        if (functionTreeNode != null && functionTreeNode.getFunction() instanceof PlsPredClassificationAreaDescriptor) {
            return false;
        }
        return super.isVisible(n);
    }

    private static List<PlsPredClassificationAreaDescriptor> getFunctionList(FunctionTreeNode functionTreeNode) {
        ArrayList<PlsPredClassificationAreaDescriptor> arrayList = new ArrayList<PlsPredClassificationAreaDescriptor>();
        arrayList.add((PlsPredClassificationAreaDescriptor)functionTreeNode.getFunction());
        for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
            AbstractBreezeFunction abstractBreezeFunction = functionTreeNode2.getFunction();
            if (!(abstractBreezeFunction instanceof PlsPredClassificationAreaDescriptor)) continue;
            PlsPredClassificationAreaDescriptor plsPredClassificationAreaDescriptor = (PlsPredClassificationAreaDescriptor)abstractBreezeFunction;
            arrayList.add(plsPredClassificationAreaDescriptor);
        }
        return arrayList;
    }

    @Generated
    public ClassParameter getClassParameter() {
        return this.classParameter;
    }

    @Generated
    public BooleanParameter getPercentParameter() {
        return this.percentParameter;
    }

    public static class SummaryImageViewContainer
    extends ViewContainer {
        private Object entrydata = null;

        public SummaryImageViewContainer(BreezeMainPanel breezeMainPanel, FunctionResult functionResult, List<Sample> list, String string) {
            super(breezeMainPanel, false);
            Object object;
            DescriptorTreeNode descriptorTreeNode = this.getRoot(functionResult);
            PlsPredClassificationAreaDescriptor plsPredClassificationAreaDescriptor = (PlsPredClassificationAreaDescriptor)descriptorTreeNode.getFunction();
            boolean bl = plsPredClassificationAreaDescriptor.getPercentParameter().getValueBool();
            final CategoryFactor categoryFactor = (CategoryFactor)descriptorTreeNode.getFactor();
            List<PlsPredClassificationAreaDescriptor> list2 = PlsPredClassificationAreaDescriptor.getFunctionList(descriptorTreeNode);
            int n = list.size();
            int n2 = Math.max(500, n);
            final int[][] nArray = new int[n2][500];
            final double[][] dArray = new double[n2][500];
            double d = (double)n2 / (double)n;
            final double d2 = (double)n / (double)n2;
            int n3 = n2 - 1;
            BufferedImage bufferedImage = new BufferedImage(n2, 500, 1);
            for (int i = 0; i < n; ++i) {
                object = list.get(i);
                int n4 = ((Sample)object).getSamplePath().getObjectPixels().size();
                double d3 = 0.0;
                double d4 = (double)i * d;
                double d5 = d4 + d;
                for (int j = 0; j < list2.size(); ++j) {
                    PlsPredClassificationAreaDescriptor plsPredClassificationAreaDescriptor2 = list2.get(j);
                    FunctionTreeNodeWithId functionTreeNodeWithId = plsPredClassificationAreaDescriptor2.getNode();
                    FunctionResult functionResult2 = ((BasicSample)object).getFunctionResult(functionTreeNodeWithId.getUid());
                    double d6 = 0.0;
                    if (functionResult2 != null) {
                        d6 = bl ? (double)functionResult2.getValue() : (double)(functionResult2.getValue() / (float)n4);
                    }
                    double d7 = d6 * 500.0;
                    CatClass catClass = plsPredClassificationAreaDescriptor2.getCatClass(categoryFactor);
                    for (double d8 = d3; d8 < d3 + d7; d8 += 1.0) {
                        int n5 = (int)Math.min(d8, 499.0);
                        for (double d9 = d4; d9 < d5; d9 += 1.0) {
                            int n6 = (int)Math.min(d9, (double)n3);
                            bufferedImage.setRGB(n6, n5, catClass.getColor().getRGB());
                            nArray[n6][n5] = categoryFactor.getClassIndex(catClass);
                            dArray[n6][n5] = d6;
                        }
                    }
                    d3 += d7;
                }
            }
            ImagePreviewPanel.ImageViewPanel imageViewPanel = new ImagePreviewPanel.ImageViewPanel(bufferedImage, new BasicPreviewPanel.TooltipCustomValue(){

                @Override
                public String getSample(int n, int n2) {
                    if (n >= 0 && n2 >= 0 && n < nArray.length && n2 < nArray[n].length) {
                        return categoryFactor.getClassByValueIdx(nArray[n][n2]).getName();
                    }
                    return "";
                }

                @Override
                public String getValue(int n, int n2) {
                    if (n >= 0 && n2 >= 0 && n < nArray.length && n2 < nArray[n].length) {
                        return RtDataFormat.toPercent(dArray[n][n2]);
                    }
                    return "";
                }

                @Override
                public double getScaleX() {
                    return d2;
                }

                @Override
                public double getScaleY() {
                    return 0.2;
                }
            });
            object = imageViewPanel.getLegend();
            ((LegendPanel)object).setTitle(categoryFactor.getName());
            ((LegendPanel)object).setClassTypes(descriptorTreeNode, categoryFactor, null);
            imageViewPanel.getPreviewPanel().showLegend(true);
            this.addViewPanel((Component)((Object)imageViewPanel), 0, 0, 1, 1);
        }

        private DescriptorTreeNode getRoot(FunctionResult functionResult) {
            DescriptorTreeNode descriptorTreeNode = functionResult.getNode();
            FunctionTreeNode functionTreeNode = descriptorTreeNode.getParent();
            if (functionTreeNode != null && functionTreeNode.getFunction() instanceof PlsPredClassificationAreaDescriptor) {
                return (DescriptorTreeNode)functionTreeNode;
            }
            return descriptorTreeNode;
        }

        @Override
        public boolean showLeftSettingsPanel() {
            return false;
        }

        @Override
        public boolean showRightSettingsPanel() {
            return false;
        }

        @Override
        public void setData(boolean bl) {
            super.showEntry(this.entrydata, null);
        }

        @Override
        public void showEntry(Object object, Object object2) {
            super.showEntry(object, object2);
            this.entrydata = object;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "count";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new PlsPredClassificationAreaDescriptor(this);
        }

        public String toString() {
            return "PlsClassificationArea";
        }

        @Override
        public String getDescription() {
            return "Number of pixels by given class";
        }

        @Override
        public String getShortDescription() {
            return "Pixels by given class";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Statistic;
        }

        @Override
        public String getHelp() {
            return "number-of-pixels-by-given-class";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("percent", "summary");
        }
    }
}

