/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.RtFramesAndRefs;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.ConnectionDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.TrainTestDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.EnumParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ParentClassParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.frame.RtFrameStackList;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.image.RtSpatialObject;
import se.prediktera.breeze.entry.sample.Sample;

public class PlsPredClassificationDescriptor
extends PlsPredDescriptor
implements CustomRenderingDescriptor,
ThumbnailDescriptor.ThumbnailQuantificationDescriptor,
ConnectionDescriptor,
PlsPredDescriptor.TableRetrainDescriptor,
AddParameter.AddFunctionInterface {
    private final ClassifyObjectOrPixelsParameter typeParameter;
    private final BooleanParameter calcPixelParameter;
    private final TextParameter weightParameter;
    private final ParentClassParameter parentClassParameter;

    public PlsPredClassificationDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addOutput("confidence");
        this.typeParameter = new ClassifyObjectOrPixelsParameter();
        this.addParameter(this.typeParameter);
        this.weightParameter = new TextParameter("weight", "Weights", "2;5;10", "Factor weights from border");
        this.addParameter(this.weightParameter);
        this.weightParameter.setVisible(() -> !this.typeParameter.isObject());
        this.calcPixelParameter = new BooleanParameter("pixel", "Pixel prediction", "Predict each individual pixel and show thumbnail", true);
        this.addParameter(this.calcPixelParameter);
        this.parentClassParameter = new ParentClassParameter();
        this.addParameter(this.parentClassParameter);
        this.addParameter(new AddParameter(this, "Show Train/Test column in table", true, null));
    }

    @Override
    public Factor getFactor(int n) {
        if (n == 1) {
            PropertyList propertyList = this.getAnalyse().getPropertyFactors();
            if (propertyList.size() == 0) {
                propertyList.add(PropertyFactor.createConfidence());
            }
            return propertyList.get(0);
        }
        return super.getFactor(n);
    }

    @Override
    public String getFactorUid(int n) {
        Factor factor = this.getFactor(n);
        if (factor != null) {
            return factor.getUid();
        }
        return super.getFactorUid(n);
    }

    @Override
    public AddParameter.AddNodeList getAddNodes() {
        return new AddParameter.AddNodeList(TrainTestDescriptor.create(this.getNode()));
    }

    @Override
    public boolean support(AbstractBreezeFunction abstractBreezeFunction) {
        return abstractBreezeFunction instanceof TrainTestDescriptor;
    }

    @Override
    public String getConnectionClass() {
        return this.parentClassParameter.getConnectionClass();
    }

    @Override
    public BasicAnalyse.ModelType getModelType() {
        return BasicAnalyse.ModelType.Classification;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        if (n == 1) {
            return "Confidence";
        }
        String string = this.getConnectionClass();
        if (((DescriptorTreeNode)functionTreeNode).isHieararchyConnectionDescriptor() && string != null) {
            return string;
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        CategoryFactor categoryFactor;
        CatClass catClass;
        Factor factor = this.getFactor(n);
        if (n == 0 && factor instanceof CategoryFactor && (catClass = (categoryFactor = (CategoryFactor)factor).getClassByValueIdx((int)f)) != null) {
            return catClass.getName();
        }
        return super.getStringValue(f, n, n2);
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        if (n == 0) {
            return ThumbnailDescriptor.ThumbType.ThumbClassification;
        }
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    @Override
    public boolean renderCellAt(int n) {
        return n == 0;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        Factor factor = this.getFactor(n3);
        if (factor instanceof CategoryFactor) {
            CategoryFactor categoryFactor = (CategoryFactor)factor;
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string, Optional.of(FunctionResult.getCategoryColorHexString(functionResult)));
    }

    @Override
    public CustomRenderingDescriptor.RenderData getSubStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string);
    }

    @Override
    public int getSmooth() {
        return 0;
    }

    @Override
    public boolean isCalculatePixel() {
        return this.calcPixelParameter.getValueBool();
    }

    public static boolean isHierarchy(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        return functionTreeNode.getFunction() instanceof PlsPredClassificationDescriptor && functionTreeNode2.getFunction() instanceof PlsPredClassificationDescriptor;
    }

    private static class ClassifyObjectOrPixelsParameter
    extends EnumParameter {
        public ClassifyObjectOrPixelsParameter() {
            super("type", "Classification type", "object", "", ObjectType.values());
        }

        public boolean isObject() {
            return !this.getValueStr().equalsIgnoreCase("Pixels");
        }

        private static enum ObjectType {
            Object("Object average spectrum"),
            Pixels("Pixel class majority");

            private final String description;

            private ObjectType(String string2) {
                this.description = string2;
            }

            public String toString() {
                return this.description;
            }
        }
    }

    public static class PixelClassification {
        private final float[] classFactorSum;

        public PixelClassification(BasicAnalyse basicAnalyse, CategoryFactor categoryFactor, RtFramesAndRefs rtFramesAndRefs, RtSpatialObject rtSpatialObject, float[] fArray) {
            RtFrameStackList.RealtimeFrameList realtimeFrameList = this.getModelFrames(basicAnalyse, rtFramesAndRefs);
            this.classFactorSum = new float[categoryFactor.getMaxSize()];
            int n = fArray.length - 1;
            rtSpatialObject.forEveryPixel((n2, n3, n4) -> {
                int n5 = (int)realtimeFrameList.getFrameValue(0, n2, n3);
                this.classFactorSum[n5] = this.classFactorSum[n5] + fArray[Math.min(n4 - 1, n)];
            });
        }

        protected RtFrameStackList.RealtimeFrameList getModelFrames(BasicAnalyse basicAnalyse, RtFramesAndRefs rtFramesAndRefs) {
            return rtFramesAndRefs.frames().getModelFrameList(basicAnalyse.getUid());
        }

        public float getMaxClass() {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < this.classFactorSum.length; ++i) {
                if (!(this.classFactorSum[i] > f)) continue;
                f2 = i;
                f = this.classFactorSum[i];
            }
            return f2;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "classification";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new PlsPredClassificationDescriptor(this);
        }

        public String toString() {
            return "PlsClassification";
        }

        @Override
        public String getDescription() {
            return "Classification of categories";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Model;
        }

        @Override
        public String getHelp() {
            return "classification-of-categories";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("plsda", "machinelearning", "onnx");
        }
    }
}

