/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.ThumbnailDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.ConnectionDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.model.TrainTestDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.OptionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.ParentClassParameter;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.entry.sample.Sample;

public class PlsPredQuantificationDescriptor
extends PlsPredDescriptor
implements ThumbnailDescriptor.ThumbnailQuantificationDescriptor,
PlsPredDescriptor.TableRetrainDescriptor,
AddParameter.AddFunctionInterface,
ConnectionDescriptor {
    private final SmoothParameter smoothParameter;
    private BooleanParameter calcPixelParameter = new BooleanParameter("pixel", "Pixel prediction", "Predict each individual pixel and show thumbnail", true);
    private ParentClassParameter parentClassParameter;

    public PlsPredQuantificationDescriptor(Info info) {
        super(info);
        this.addParameter(this.calcPixelParameter);
        this.smoothParameter = new SmoothParameter();
        this.addParameter(this.smoothParameter);
        this.smoothParameter.setVisible(() -> this.calcPixelParameter.getValueBool());
        this.parentClassParameter = new ParentClassParameter();
        this.addParameter(this.parentClassParameter);
        this.addParameter(new AddParameter(this, "Show Train/Test column in table", true, null));
    }

    @Override
    public String getConnectionClass() {
        return this.parentClassParameter.getConnectionClass();
    }

    @Override
    public AddParameter.AddNodeList getAddNodes() {
        return new AddParameter.AddNodeList(TrainTestDescriptor.create(this.getNode()));
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        String string;
        if (textType.isTable() && ConnectedQuantificationFunctionResult.isHierarchical(functionTreeNode) && (string = this.getConnectionClass()) != null && string.length() > 0) {
            return functionTreeNode.getParent().getAliasOrNodeString(textType) + " (Quantification)";
        }
        return super.getNodeString(functionTreeNode, n, textType);
    }

    @Override
    public boolean support(AbstractBreezeFunction abstractBreezeFunction) {
        return abstractBreezeFunction instanceof TrainTestDescriptor;
    }

    @Override
    public MinMax getMinMax(int n) {
        Factor factor = this.getFactor(0);
        if (factor != null) {
            return new MinMax(factor.getMin(), factor.getMax());
        }
        return new MinMax();
    }

    @Override
    public boolean isCalculatePixel() {
        return this.calcPixelParameter.getValueBool();
    }

    @Override
    public int getSmooth() {
        return this.smoothParameter.getSmooth();
    }

    @Override
    public BasicAnalyse.ModelType getModelType() {
        return BasicAnalyse.ModelType.Quantification;
    }

    @Override
    public ThumbnailDescriptor.ThumbType getThumbType(int n) {
        return ThumbnailDescriptor.ThumbType.ThumbQuantification;
    }

    public static class SmoothParameter
    extends OptionParameter {
        public SmoothParameter() {
            super("smooth", "Smooth", "none", "Smooth prediction result using median filter kernel");
            this.add(new KernelOption("none", "None", 0));
            this.add(new KernelOption("low", "Low - 5 px", 5));
            this.add(new KernelOption("medium", "Medium - 10 px", 10));
            this.add(new KernelOption("high", "High - 15 px", 15));
        }

        public int getSmooth() {
            return ((KernelOption)this.getValueObj()).kernel;
        }

        private static class KernelOption
        extends OptionParameter.Option {
            private final int kernel;

            public KernelOption(String string, String string2, int n) {
                super(string, string2);
                this.kernel = n;
            }
        }
    }

    public static class ConnectedQuantificationFunctionResult
    extends FunctionResult {
        private final Sample sample;
        private final DescriptorTreeNode parent;
        private final HashMap<Integer, DescriptorTreeNode> hashMap = new HashMap();

        public ConnectedQuantificationFunctionResult(DescriptorTreeNode descriptorTreeNode, Node node, Sample sample) {
            super(descriptorTreeNode, node);
            this.sample = sample;
            this.parent = (DescriptorTreeNode)descriptorTreeNode.getParent();
            Factor factor = this.parent.getFactor();
            if (factor instanceof CategoryFactor) {
                CategoryFactor categoryFactor = (CategoryFactor)factor;
                for (FunctionTreeNode functionTreeNode : this.parent.getChildList()) {
                    PlsPredQuantificationDescriptor plsPredQuantificationDescriptor;
                    Object object = functionTreeNode.getFunction();
                    if (!(object instanceof PlsPredQuantificationDescriptor) || (object = ConnectionDescriptor.getClass((plsPredQuantificationDescriptor = (PlsPredQuantificationDescriptor)object).getConnectionClass(), functionTreeNode)) == null) continue;
                    this.hashMap.put(categoryFactor.getClassIndex((CatClass)object), (DescriptorTreeNode)functionTreeNode);
                }
            }
        }

        @Override
        public String getStringValueWithUnit() {
            return super.getStringValueWithUnit();
        }

        public DescriptorTreeNode getClassificationNode() {
            FunctionResult functionResult = this.sample.getFunctionResult(this.parent.getUid());
            if (functionResult != null) {
                return this.hashMap.get((int)functionResult.getValue());
            }
            return null;
        }

        @Override
        public boolean isMissing() {
            return this.getClassificationNode() == null;
        }

        @Override
        public float getValue() {
            FunctionResult functionResult;
            DescriptorTreeNode descriptorTreeNode = this.getClassificationNode();
            if (descriptorTreeNode != null && (functionResult = this.sample.getFunctionResult(descriptorTreeNode.getUid())) != null) {
                return functionResult.value;
            }
            return 0.0f;
        }

        public boolean hasNode(DescriptorTreeNode descriptorTreeNode) {
            return this.hashMap.containsValue(descriptorTreeNode);
        }

        public static DescriptorTreeNode getHierarchyNode(DescriptorTreeNode descriptorTreeNode, Sample sample, boolean bl) {
            if (ConnectedQuantificationFunctionResult.isHierarchical(descriptorTreeNode)) {
                DescriptorTreeNode descriptorTreeNode2;
                ConnectedQuantificationFunctionResult connectedQuantificationFunctionResult = (ConnectedQuantificationFunctionResult)sample.getFunctionResult(descriptorTreeNode.getUid());
                if (connectedQuantificationFunctionResult != null && (descriptorTreeNode2 = connectedQuantificationFunctionResult.getClassificationNode()) != null) {
                    return descriptorTreeNode2;
                }
                return null;
            }
            if (bl) {
                return descriptorTreeNode;
            }
            return null;
        }

        public static boolean isHierarchical(FunctionTreeNode functionTreeNode) {
            PlsPredQuantificationDescriptor plsPredQuantificationDescriptor;
            AbstractBreezeFunction abstractBreezeFunction = functionTreeNode.getFunction();
            return abstractBreezeFunction instanceof PlsPredQuantificationDescriptor && (plsPredQuantificationDescriptor = (PlsPredQuantificationDescriptor)abstractBreezeFunction).getConnectionClass() != null && functionTreeNode.getParent() != null && functionTreeNode.getParent().getFactor() instanceof CategoryFactor;
        }
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "quantification";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new PlsPredQuantificationDescriptor(this);
        }

        public String toString() {
            return "PlsPred";
        }

        @Override
        public String getDescription() {
            return "Quantification of properties";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Model;
        }

        @Override
        public String getHelp() {
            return "quantification-of-properties";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("pls", "machinelearning", "onnx");
        }
    }
}

