/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.util.Arrays;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.AbstractModelDescriptor;
import se.prediktera.breeze.common.util.StringHelper;

public class PlsPredStatisticsDescriptor
extends AbstractModelDescriptor {
    public PlsPredStatisticsDescriptor(AbstractDescriptorInfo abstractDescriptorInfo) {
        super(abstractDescriptorInfo);
        this.addOutput("absoluteError");
        this.addOutput("relativeError");
        this.addOutput("percentageError");
    }

    @Override
    public BasicAnalyse.ModelType getModelType() {
        return BasicAnalyse.ModelType.Quantification;
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        String string = StringHelper.formatLabel(this.getOutputName(n));
        Factor factor = this.getFactor(n);
        if (factor != null) {
            return string + " (" + factor.getName() + ")";
        }
        return string;
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "statistics";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new PlsPredStatisticsDescriptor(this);
        }

        public String toString() {
            return "PlsPredStatistics";
        }

        @Override
        public String getDescription() {
            return "Statistics for quantification of properties";
        }

        @Override
        public String getShortDescription() {
            return "Statistics (properties)";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Statistic;
        }

        @Override
        public String getHelp() {
            return "statistics-quantification-of-properties";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("error");
        }
    }
}

