/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.model;

import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.sample.BasicSample;
import se.prediktera.breeze.common.entry.tree.AbstractCardInfo;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunctionInfo;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionHelper;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionResult;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptorInfo;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.util.CustomRenderingDescriptor;
import se.prediktera.breeze.common.util.UniqueUID;
import se.prediktera.breeze.entry.analyse.Analyse;
import se.prediktera.breeze.entry.analyse.AnalyseSample;
import se.prediktera.breeze.entry.sample.Sample;

public class TrainTestDescriptor
extends AbstractDescriptor
implements CustomRenderingDescriptor,
PlsPredDescriptor.TableRetrainDescriptor {
    private IDParameter.IDAnalyseParameter analyseParameter;
    private final CategoryFactor trainTestCategory = new CategoryFactor("TrainTest", UniqueUID.getUniqueId());

    public TrainTestDescriptor(AbstractBreezeFunctionInfo abstractBreezeFunctionInfo) {
        super(abstractBreezeFunctionInfo);
        for (AnalyseSample.SampleIncluded sampleIncluded : Arrays.asList(AnalyseSample.SampleIncluded.None, AnalyseSample.SampleIncluded.AllTrain, AnalyseSample.SampleIncluded.AllTest)) {
            this.trainTestCategory.addClass(sampleIncluded.format(), sampleIncluded.color());
        }
        this.analyseParameter = new IDParameter.IDAnalyseParameter("analyse", "Analyse", "");
        this.addParameter(this.analyseParameter);
        this.addOutput("value");
    }

    @Override
    public String getNodeString(FunctionTreeNode functionTreeNode, int n, FunctionTreeNode.TextType textType) {
        FunctionTreeNodeWithId functionTreeNodeWithId = this.analyseParameter.getNode(functionTreeNode);
        if (functionTreeNodeWithId != null) {
            return "Train/Test (" + functionTreeNodeWithId.getAliasOrNodeString() + ")";
        }
        return "Train/Test";
    }

    @Override
    public String getStringValue(float f, int n, int n2) {
        return this.trainTestCategory.getClasses().get((int)f).getName();
    }

    public IDParameter.IDAnalyseParameter getAnalyseParameter() {
        return this.analyseParameter;
    }

    @Override
    public BasicAnalyse getAnalyse() {
        return this.analyseParameter.getAnalyse(this.getNode());
    }

    @Override
    public Factor getFactor(int n) {
        return this.trainTestCategory;
    }

    @Override
    public boolean isVisible(int n) {
        return false;
    }

    @Override
    public boolean renderCellAt(int n) {
        return true;
    }

    @Override
    public void renderCell(Sample sample, float f, Graphics graphics, int n, int n2, int n3) {
        CategoryFactor categoryFactor;
        if (f > 0.0f && (categoryFactor = (CategoryFactor)this.getFactor(n3)) != null) {
            CatClass.render(graphics, categoryFactor.getClassByValueIdx((int)f), n2);
        }
    }

    @Override
    public CustomRenderingDescriptor.RenderData getStringValueAndOptionalBoxColor(String string, FunctionResult functionResult) {
        return new CustomRenderingDescriptor.RenderData(string, Optional.of(FunctionResult.getCategoryColorHexString(functionResult)));
    }

    public static AddParameter.AddNode create(FunctionTreeNode functionTreeNode) {
        DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)FunctionHelper.createNew(new Info());
        TrainTestDescriptor trainTestDescriptor = (TrainTestDescriptor)descriptorTreeNode.getFunction();
        trainTestDescriptor.getAnalyseParameter().setValue(functionTreeNode);
        return new AddParameter.AddNode(descriptorTreeNode, functionTreeNode);
    }

    public static class Info
    extends AbstractDescriptorInfo {
        @Override
        public String getImageIcon() {
            return "traintest";
        }

        @Override
        public AbstractBreezeFunction createFunction() {
            return new TrainTestDescriptor(this);
        }

        public String toString() {
            return "TrainTest";
        }

        @Override
        public String getDescription() {
            return "Train test";
        }

        @Override
        public AbstractCardInfo.GroupType getGroup() {
            return AbstractCardInfo.GroupType.Model;
        }

        @Override
        public String getHelp() {
            return "traintest";
        }

        @Override
        public List<String> getKeywords() {
            return Arrays.asList("train", "test");
        }

        @Override
        public boolean isVisibleInList() {
            return false;
        }
    }

    public static class TrainTestFunctionResult
    extends FunctionResult {
        private final BasicSample sample;

        public TrainTestFunctionResult(DescriptorTreeNode descriptorTreeNode, Sample sample) {
            super(descriptorTreeNode);
            this.sample = sample;
            this.setValue(0.0f);
        }

        public TrainTestFunctionResult(DescriptorTreeNode descriptorTreeNode, Node node, Sample sample) {
            super(descriptorTreeNode, node);
            this.sample = sample;
        }

        @Override
        public String getStringValueWithUnit() {
            return super.getStringValueWithUnit();
        }

        @Override
        public float getValue() {
            BasicAnalyse basicAnalyse = this.getAnalyse();
            if (basicAnalyse != null) {
                return ((Analyse)basicAnalyse).sampleIncluded(this.sample).type();
            }
            return 0.0f;
        }
    }
}

