/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public abstract class AbstractParameter
implements FunctionParameter {
    private final String name;
    private final String backwardCompatibilityName;
    private String alias;
    private String usage;
    private boolean editable = true;
    private boolean visible = true;
    private ParameterCallback visibleCallback;
    private ParameterCallback editableCallback;

    public AbstractParameter(String string, String string2, String string3, String string4) {
        this.name = string;
        this.alias = string2;
        this.usage = string3;
        this.backwardCompatibilityName = string4;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBackwardCompatibilityName() {
        return this.backwardCompatibilityName;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    @Override
    public String getAliasOrName() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.getName();
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    @Override
    public void copy(FunctionParameter functionParameter) {
        Object object = functionParameter.getValueObj();
        if (object != null) {
            this.setValue(object);
        }
    }

    @Override
    public Object getValueObj() {
        return this.getValueStr();
    }

    @Override
    public int getValueHashCode() {
        return StringHelper.hashCode(this.getValueStr());
    }

    @Override
    public boolean setValue(Object object) {
        this.setValueStr(object.toString());
        return true;
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        return null;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public boolean isEditable() {
        if (this.editableCallback != null) {
            return this.editableCallback.isTrue();
        }
        return this.editable;
    }

    public void setEditable(ParameterCallback parameterCallback) {
        this.editableCallback = parameterCallback;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean isVisible(FunctionTreeNode functionTreeNode) {
        if (this.visibleCallback != null) {
            return this.visibleCallback.isTrue();
        }
        return this.visible;
    }

    public void setVisible(ParameterCallback parameterCallback) {
        this.visibleCallback = parameterCallback;
    }

    public String toString() {
        return this.format(null, null);
    }

    @Override
    public String format(Workflow workflow, FunctionTreeNode functionTreeNode) {
        return StringHelper.formatLabel(this.getName()) + " = " + this.getFormatValue(workflow);
    }

    protected String getFormatValue(Workflow workflow) {
        Object object = this.getValueObj();
        if (object != null) {
            if (object instanceof FunctionTreeNode) {
                FunctionTreeNode functionTreeNode = (FunctionTreeNode)object;
                return functionTreeNode.getAliasOrNodeString();
            }
            if (object instanceof Double) {
                Double d = (Double)object;
                return RtDataFormat.toString(d);
            }
            return object.toString();
        }
        return this.getValueStr();
    }

    public static interface ParameterCallback {
        public boolean isTrue();
    }
}

