/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.frontend.BreezeFrame;
import se.prediktera.breeze.frontend.common.entry.EntryMainHelper;
import se.prediktera.breeze.frontend.common.swing.BreezeSeparator;
import se.prediktera.breeze.frontend.common.swing.BreezeTextField;
import se.prediktera.breeze.frontend.common.swing.dialog.AbstractBreezeCustomPanel;
import se.prediktera.breeze.frontend.common.swing.table.BreezeIntervalClass;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTable;
import se.prediktera.breeze.frontend.common.swing.table.BreezeTablePanel;
import se.prediktera.breeze.frontend.common.swing.table.DefaultBreezeTableImpl;

public class AddParameter
extends BooleanParameter {
    private final AddFunctionInterface addFunction;
    private final boolean checkBox;
    private final NumberParameter numberParameter;

    public AddParameter(AddFunctionInterface addFunctionInterface, String string, boolean bl, NumberParameter numberParameter) {
        super("add", string, "", false);
        this.addFunction = addFunctionInterface;
        this.checkBox = bl;
        this.numberParameter = numberParameter;
    }

    public AddFunctionInterface getAddFunction() {
        return this.addFunction;
    }

    public boolean isCheckBox() {
        return this.checkBox;
    }

    public NumberParameter getNumberParameter() {
        return this.numberParameter;
    }

    public static interface AddFunctionInterface {
        public AddNodeList getAddNodes();

        public boolean support(AbstractBreezeFunction var1);

        default public void clearSupported(FunctionTreeNode functionTreeNode) {
            List<FunctionTreeNode> list = functionTreeNode.getChildren();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!this.support(list.get(i).getFunction())) continue;
                list.remove(i);
            }
        }

        default public FunctionTreeNodeWithId getNodeOrParent(FunctionTreeNodeWithId functionTreeNodeWithId) {
            FunctionTreeNode functionTreeNode = functionTreeNodeWithId.getParent();
            if (!functionTreeNodeWithId.isVisible() && functionTreeNode != null && this.support(functionTreeNode.getFunction())) {
                return (FunctionTreeNodeWithId)functionTreeNode;
            }
            return functionTreeNodeWithId;
        }
    }

    public static class NodeTableModel
    extends DefaultBreezeTableImpl {
        private final String header;

        public NodeTableModel(String string) {
            this.header = string;
        }

        @Override
        public Vector createVOVector(Object object) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(object);
            return vector;
        }

        @Override
        public List<Object> getTableHeader(List list) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.header);
            return arrayList;
        }
    }

    public static class AddClass
    extends BreezeIntervalClass {
        private final AddBasic add;

        public AddClass(AddBasic addBasic) {
            this.add = addBasic;
            this.setIncluded(addBasic.included);
        }

        @Override
        public String toString() {
            return this.add.getName();
        }

        public Object getObject() {
            return this.add.getObject();
        }
    }

    public static class AddNodeList
    extends ArrayList<AddNode> {
        public AddNodeList() {
        }

        public AddNodeList(AddNode addNode) {
            this.add(addNode);
        }

        public int getNumberIncluded() {
            int n = 0;
            for (AddNode addNode : this) {
                if (!addNode.included) continue;
                ++n;
            }
            return n;
        }

        public static int getNumberIncluded(FunctionTreeNode functionTreeNode, AddFunctionInterface addFunctionInterface) {
            int n = 0;
            for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
                if (!addFunctionInterface.support(functionTreeNode2.getFunction())) continue;
                ++n;
            }
            return n;
        }
    }

    public static class AddNode
    extends AddBasic {
        public final DescriptorTreeNode node;

        public AddNode(DescriptorTreeNode descriptorTreeNode, FunctionTreeNode functionTreeNode) {
            this.node = descriptorTreeNode;
            this.included = AddNode.hasChild(functionTreeNode, descriptorTreeNode);
        }

        @Override
        public Object getObject() {
            return this.node;
        }

        @Override
        public String getName() {
            return this.node.getAliasOrSimpleNodeString();
        }

        private static boolean hasChild(FunctionTreeNode functionTreeNode, DescriptorTreeNode descriptorTreeNode) {
            for (FunctionTreeNode functionTreeNode2 : functionTreeNode.getChildList()) {
                if (!functionTreeNode2.getAliasOrSimpleNodeString().equals(descriptorTreeNode.getAliasOrSimpleNodeString())) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class AddBasic {
        public boolean included;

        public abstract Object getObject();

        public abstract String getName();
    }

    public static class AddParameterSelectionPanel
    extends AbstractBreezeCustomPanel {
        private final BreezeTablePanel selectionTablePanel = new BreezeTablePanel();
        private final ArrayList<AddClass> nodeList = new ArrayList();
        private final BreezeTextField inputTextField;

        public AddParameterSelectionPanel(List<? extends AddBasic> list, String string) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(false);
            JPanel jPanel = new JPanel(new FlowLayout(0, 10, 5));
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 20, 0, 0);
            this.add((Component)jPanel, gridBagConstraints);
            BreezeTable breezeTable = this.selectionTablePanel.getTable();
            jPanel.add(EntryMainHelper.createButton("Include", "include", () -> this.changeIncluded(true, false)));
            jPanel.add(EntryMainHelper.createButton("Include Only", "include_only", () -> this.changeIncluded(true, true)));
            jPanel.add(EntryMainHelper.createButton("Exclude", "exclude", () -> this.changeIncluded(false, false)));
            jPanel.add(new BreezeSeparator(1, 4, 60));
            jPanel.add(EntryMainHelper.createButton("Select all", "selectall", () -> breezeTable.selectAll()));
            jPanel.add(EntryMainHelper.createButton("Deselect all", "deselectall", () -> breezeTable.clearSelection()));
            breezeTable.setSelectionMode(2);
            this.selectionTablePanel.initTable(new NodeTableModel(string), null, false);
            this.selectionTablePanel.addIntervalListener(new int[]{0}, () -> this.selectionTablePanel.repaint());
            this.selectionTablePanel.setSortable(true);
            this.selectionTablePanel.addRowHeader();
            this.selectionTablePanel.setRowHeight(30);
            this.selectionTablePanel.getScrollPane().setHorizontalScrollBarPolicy(31);
            breezeTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {});
            for (AddBasic addBasic : list) {
                this.nodeList.add(new AddClass(addBasic));
            }
            this.selectionTablePanel.setTableList(this.nodeList, this.nodeList.isEmpty() ? null : this.nodeList.get(0));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(10, 20, 10, 20);
            this.add((Component)((Object)this.selectionTablePanel), gridBagConstraints);
            this.inputTextField = new BreezeTextField();
            this.setPreferredSize(new Dimension(700, (int)(BreezeFrame.getScreenSize().getHeight() * 0.75)));
        }

        private void changeIncluded(boolean bl, boolean bl2) {
            if (bl2) {
                BreezeTable breezeTable = this.selectionTablePanel.getTable();
                for (int i = 0; i < breezeTable.getRowCount(); ++i) {
                    ((BreezeIntervalClass)breezeTable.getValueAt(i, 0)).setIncluded(false);
                }
            }
            for (Object e : this.selectionTablePanel.getSelectedValues()) {
                ((BreezeIntervalClass)e).setIncluded(bl);
            }
            this.selectionTablePanel.repaint();
        }

        @Override
        public boolean usePreferredSize() {
            return true;
        }

        @Override
        public Object getResult() {
            return this.inputTextField.getText();
        }

        public List<AddClass> getNodeList() {
            return this.nodeList;
        }

        public List<AddClass> getSelectedNodes() {
            ArrayList<AddClass> arrayList = new ArrayList<AddClass>();
            for (AddClass addClass : this.nodeList) {
                if (!addClass.isIncluded()) continue;
                arrayList.add(addClass);
            }
            return arrayList;
        }
    }

    public static interface AddFunctionWithAliasInterface
    extends AddFunctionInterface {
        default public String format(FunctionTreeNode functionTreeNode, String string) {
            String string2 = this.getRootAlias(functionTreeNode);
            if (string2 != null) {
                return string2 + " (" + string + ")";
            }
            return string;
        }

        default public String getRootAlias(FunctionTreeNode functionTreeNode) {
            AddFunctionInterface addFunctionInterface;
            AbstractBreezeFunction abstractBreezeFunction;
            FunctionTreeNode functionTreeNode2 = functionTreeNode.getParent();
            if (functionTreeNode2 != null && (abstractBreezeFunction = functionTreeNode2.getFunction()) instanceof AddFunctionInterface && (addFunctionInterface = (AddFunctionInterface)((Object)abstractBreezeFunction)).support(functionTreeNode.getFunction())) {
                return functionTreeNode2.getAlias();
            }
            return functionTreeNode.getAlias();
        }
    }
}

