/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.model.PlsPredClassificationDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.entry.workflow.Workflow;

public class AnalyseFactorParameter
extends TextParameter {
    private final AnalyseInterface descriptor;

    public AnalyseFactorParameter(String string, AnalyseInterface analyseInterface) {
        super(string, "Factor", "id", null);
        this.descriptor = analyseInterface;
    }

    @Override
    public String getAliasOrName() {
        BasicAnalyse basicAnalyse = this.descriptor.getAnalyse();
        if (basicAnalyse != null) {
            if (basicAnalyse.getModelMethod().isQuantification()) {
                return "Quantification";
            }
            return "Classification";
        }
        return super.getAliasOrName();
    }

    @Override
    public boolean setValue(Object object) {
        this.setValueStr(((Factor)object).getUid());
        return true;
    }

    @Override
    public Object getValueObj() {
        return this.getFactor();
    }

    public Factor getFactor() {
        BasicAnalyse basicAnalyse = this.descriptor.getAnalyse();
        if (basicAnalyse != null) {
            return basicAnalyse.getFactor(this.getValueStr());
        }
        return null;
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        BasicAnalyse basicAnalyse = this.descriptor.getAnalyse();
        if (basicAnalyse != null) {
            if (basicAnalyse.getModelMethod().isQuantification()) {
                return basicAnalyse.getPropertyFactors().getList().toArray();
            }
            return basicAnalyse.getCategoryFactors().getList().toArray();
        }
        return new Object[0];
    }

    @Override
    public boolean updateParameterRecursive(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        return !PlsPredClassificationDescriptor.isHierarchy(functionTreeNode, functionTreeNode2);
    }

    public static interface AnalyseInterface {
        public BasicAnalyse getAnalyse();
    }
}

