/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.factor.category.CatClass;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.ClassParameterDescriptorInterface;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.IDParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.realtime.descriptor.spectralLibraries.GroupCatClass;
import se.prediktera.breeze.common.realtime.descriptor.usgs.groups.MicaGroups;
import se.prediktera.breeze.entry.workflow.Workflow;

public class ClassParameter
extends TextParameter {
    private final ClassParameterDescriptorInterface descriptor;
    private final IDParameter.IDClassifcationParameter categoryFactor;
    private String classId;

    public ClassParameter(String string, String string2, ClassParameterDescriptorInterface classParameterDescriptorInterface) {
        this(string, "", string2, classParameterDescriptorInterface);
    }

    public ClassParameter(String string, String string2, String string3, ClassParameterDescriptorInterface classParameterDescriptorInterface) {
        super(string, string3, string2, "");
        this.descriptor = classParameterDescriptorInterface;
        this.categoryFactor = null;
    }

    public ClassParameter(String string, String string2, String string3, IDParameter.IDClassifcationParameter iDClassifcationParameter) {
        super(string, string3, string2, "");
        this.descriptor = null;
        this.categoryFactor = iDClassifcationParameter;
    }

    @Override
    public boolean setValue(Object object) {
        String string;
        this.setValueStr(object.toString());
        if (object instanceof ClassParameterOption) {
            ClassParameterOption classParameterOption = (ClassParameterOption)object;
            string = classParameterOption.id;
        } else {
            string = null;
        }
        this.classId = string;
        return true;
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        element2.setAttribute("classParameterId", this.classId);
        return element2;
    }

    public CatClass getCatClass(FunctionTreeNode functionTreeNode) {
        CategoryFactor categoryFactor;
        if (this.categoryFactor != null) {
            return this.categoryFactor.getFactor(functionTreeNode).getClass(this.getValueStr());
        }
        if (this.descriptor != null && (categoryFactor = this.descriptor.getCategoryFactor(functionTreeNode)) != null) {
            return categoryFactor.getClass(this.getValueStr());
        }
        return null;
    }

    @Override
    public void copy(FunctionParameter functionParameter) {
        super.copy(functionParameter);
        this.classId = ((ClassParameter)functionParameter).classId;
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        CategoryFactor categoryFactor;
        CategoryFactor categoryFactor2 = this.categoryFactor != null ? this.categoryFactor.getFactor() : (categoryFactor = this.descriptor != null ? this.descriptor.getCategoryFactor(functionTreeNode) : null);
        if (categoryFactor != null) {
            List<CatClass> list = categoryFactor.getGroupedClasses();
            Object[] objectArray = new ClassParameterOption[list.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                CatClass catClass = list.get(i);
                String string = catClass.getUid();
                if (catClass instanceof MicaGroups.MicaCatClass) {
                    MicaGroups.MicaCatClass micaCatClass = (MicaGroups.MicaCatClass)catClass;
                    string = micaCatClass.getActualClassName();
                } else if (catClass instanceof GroupCatClass) {
                    GroupCatClass groupCatClass = (GroupCatClass)catClass;
                    string = groupCatClass.getActualClassName();
                }
                objectArray[i] = new ClassParameterOption(catClass.getName(), string);
            }
            return objectArray;
        }
        return new Object[0];
    }

    @Override
    public Object getValueObj() {
        return new ClassParameterOption(this.getValueStr(), this.classId);
    }

    public CatClass getCatClass(CategoryFactor categoryFactor) {
        if (categoryFactor != null) {
            return categoryFactor.getClass(this.getValueStr());
        }
        return null;
    }

    @Override
    public void parse(Node node) {
        super.parse(node);
        Node node2 = node.getAttributes().getNamedItem("classParameterId");
        if (node2 != null) {
            this.classId = node2.getNodeValue();
        }
    }

    record ClassParameterOption(String displayName, String id) {
        @Override
        public String toString() {
            return this.displayName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object object) {
            if (object instanceof ClassParameterOption) {
                ClassParameterOption classParameterOption = (ClassParameterOption)object;
                if (this.displayName.equals(classParameterOption.displayName)) return true;
            }
            if (!object.toString().equals(this.displayName)) return false;
            return true;
        }
    }
}

