/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.util.polynom.RtPolyNode;
import se.prediktera.breeze.common.util.polynom.RtPolynomParser;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public abstract class ExpressionParameter<T extends Expression>
extends TextParameter {
    protected final List<T> expressionLists = new ArrayList<T>();

    public ExpressionParameter(String string, String string2, String string3) {
        this("expression", string, string2, string3);
    }

    public ExpressionParameter(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    @Override
    public Element save(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "param");
        XmlParserHelper.setAttribute((Node)element2, "name", this.getName());
        for (Expression expression : this.expressionLists) {
            expression.save(element2);
        }
        return element2;
    }

    @Override
    public void parse(Node node) {
        this.expressionLists.clear();
        for (Node node2 : XmlParserHelper.parseChildNodes(node, "expression")) {
            this.add(this.createList(node2));
        }
    }

    protected abstract T createList(Node var1);

    public void add(T t) {
        this.expressionLists.add(t);
    }

    public List<T> getExpressionLists() {
        return this.expressionLists;
    }

    public final String getExpression() {
        Expression expression;
        if (this.expressionLists.size() > 0 && (expression = (Expression)this.expressionLists.get(0)) != null) {
            return expression.getExpression();
        }
        return "";
    }

    @Override
    protected String getFormatValue(Workflow workflow) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Expression expression : this.expressionLists) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("@");
            }
            stringBuilder.append(expression.getExpression());
        }
        return stringBuilder.toString();
    }

    @Override
    public void copy(FunctionParameter functionParameter) {
        this.expressionLists.clear();
        for (T t : ((ExpressionParameter)functionParameter).getExpressionLists()) {
            this.add(((Expression)t).clone(functionParameter));
        }
    }

    @Override
    public int getValueHashCode() {
        int n = 1;
        for (Expression expression : this.expressionLists) {
            int n2;
            String string = expression.getExpression();
            if (string == null || (n2 = string.hashCode()) == 0) continue;
            n *= n2;
        }
        return n;
    }

    public static abstract class Expression<T>
    implements Cloneable {
        private String expression;
        protected RtPolynomParser parser = new RtPolynomParser();
        protected List<BandNode> bandList = new ArrayList<BandNode>();

        public Expression() {
        }

        public Expression(Node node) {
            this.set(node.getTextContent());
        }

        public Element save(Element element) {
            Element element2 = XmlParserHelper.addElement(element, "expression");
            XmlParserHelper.addCDATA(element2, this.expression);
            return element2;
        }

        public void set(String string) {
            this.expression = string;
        }

        public String getExpression() {
            return this.expression;
        }

        protected Expression<T> clone(FunctionParameter functionParameter) {
            try {
                Expression expression = (Expression)super.clone();
                expression.parser = new RtPolynomParser();
                expression.bandList = new ArrayList<BandNode>();
                return expression;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        protected static class BandNode {
            public int band;
            public RtPolyNode node;

            public BandNode(int n, RtPolyNode rtPolyNode) {
                this.band = n;
                this.node = rtPolyNode;
            }
        }
    }

    public static class ExpressionMissingException
    extends RuntimeException {
        public ExpressionMissingException(String string) {
            super(string);
        }
    }
}

