/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FolderParameter;
import se.prediktera.breeze.common.util.FileHelper;
import se.prediktera.map.common.swing.filechooser.jopensaveDialog;

public class FileParameter
extends FolderParameter {
    public FileParameter(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    @Override
    public void customizeDialog(jopensaveDialog jopensaveDialog2) {
        jopensaveDialog2.setCurrentDirectory(this.getDefaultFolder());
        jopensaveDialog2.addExtension(new String[]{"txt", "csv"}, "CSV and txt files");
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof File) {
            File file = (File)object;
            super.setValue(file.getAbsolutePath());
            return true;
        }
        return super.setValue(object);
    }

    public static class ExtensionFilter
    extends FileFilter {
        public String[] ext;
        public String description;
        public byte exttype;
        public Object object;

        public ExtensionFilter(String string, String string2) {
            this(new String[]{string}, string2, 0, null);
        }

        public ExtensionFilter(String[] stringArray, String string, byte by, Object object) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].toLowerCase();
            }
            this.exttype = by;
            this.ext = stringArray;
            this.description = string;
            this.object = object;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = FileHelper.getFileExtension(file);
            for (String string2 : this.ext) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String getExtension(int n) {
            return this.ext[n];
        }

        public byte getExtType() {
            return this.exttype;
        }

        public int getNumberOfExtensions() {
            return this.ext.length;
        }

        public boolean hasExtension(File file) {
            String string = FileHelper.getFileExtension(file);
            if (string.length() > 0) {
                for (String string2 : this.ext) {
                    if (!string.equalsIgnoreCase(string2)) continue;
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.description;
        }
    }
}

