/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import se.prediktera.breeze.backend.WorkspaceManager;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FileParameter;
import se.prediktera.breeze.test.stubs.WorkflowWithoutIO;
import se.prediktera.map.common.update.UpdateHelper;

public class FileParameterTest {
    @Test
    public void testParameterEditable() {
        FileParameter fileParameter = new FileParameter("test", "Test", "", "");
        Assert.assertTrue((boolean)fileParameter.isEditable());
    }

    @Test
    public void testParameterVisible() {
        FileParameter fileParameter = new FileParameter("test", "Test", "", "");
        Assert.assertTrue((boolean)fileParameter.isVisible(null));
    }

    @Test
    public void testParamererValue() {
        FileParameter fileParameter = new FileParameter("test", "Test", "", "");
        if (UpdateHelper.getPlatform().equals((Object)UpdateHelper.Platform.Windows)) {
            fileParameter.setValueStr("C:\\test\\test.txt");
            Assert.assertEquals((Object)"C:\\test\\test.txt", (Object)fileParameter.getFile(new WorkflowWithoutIO()).getAbsolutePath());
        }
    }

    @Test
    public void testParamererValueWithConstants() {
        if (UpdateHelper.getPlatform().equals((Object)UpdateHelper.Platform.Windows)) {
            FileParameter fileParameter = new FileParameter("test", "Test", "", "");
            final File file = new File("C:\\workspace");
            WorkspaceManager.getInstance().overrideWorkspacePath(file);
            WorkflowWithoutIO workflowWithoutIO = new WorkflowWithoutIO(this){

                @Override
                public File getFolder() {
                    return new File(file, "Record/workflow");
                }
            };
            fileParameter.setValueStr("$workspace\\test.txt");
            Assert.assertEquals((Object)"C:\\workspace\\test.txt", (Object)fileParameter.getFile(workflowWithoutIO).getAbsolutePath());
            fileParameter.setValueStr("$record\\test.txt");
            Assert.assertEquals((Object)"C:\\workspace\\Record\\test.txt", (Object)fileParameter.getFile(workflowWithoutIO).getAbsolutePath());
            fileParameter.setValueStr("$play\\test.txt");
            Assert.assertEquals((Object)"C:\\workspace\\Play\\test.txt", (Object)fileParameter.getFile(workflowWithoutIO).getAbsolutePath());
            fileParameter.setValueStr("$workflow\\test.txt");
            Assert.assertEquals((Object)"C:\\workspace\\Record\\workflow\\test.txt", (Object)fileParameter.getFile(workflowWithoutIO).getAbsolutePath());
        }
    }
}

