/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.util.ArrayList;
import java.util.List;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.category.CategoryFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNodeList;
import se.prediktera.breeze.common.entry.tree.functiontree.AbstractBreezeFunction;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNodeWithId;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AnalyseFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.PropertyFactorParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.entry.workflow.Workflow;

public class IDParameter
extends TextParameter {
    private FunctionTreeNodeWithId[] options;

    public IDParameter() {
        this("id");
    }

    public IDParameter(String string) {
        this(string, null, null);
    }

    public IDParameter(String string, String string2, String string3) {
        super(string, string2, "0", string3);
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof FunctionTreeNodeWithId) {
            super.setValue(((FunctionTreeNodeWithId)object).getUid());
            return true;
        }
        return false;
    }

    public void setId(String string) {
        this.setValueStr(string);
    }

    public String getId() {
        return this.getValueStr();
    }

    @Override
    public Object getValueObj() {
        if (this.options != null) {
            for (FunctionTreeNodeWithId functionTreeNodeWithId : this.options) {
                if (!functionTreeNodeWithId.getUid().equals(this.getId())) continue;
                return functionTreeNodeWithId;
            }
        }
        return this.getId();
    }

    public FunctionTreeNodeWithId getNode(FunctionTreeNode functionTreeNode) {
        FunctionTreeNode functionTreeNode2 = functionTreeNode.getRoot();
        if (functionTreeNode2 != null) {
            return functionTreeNode2.getNodeById(this.getId());
        }
        return null;
    }

    public int getNumberOfOptions(FunctionTreeNode functionTreeNode) {
        Object[] objectArray = this.getOptions(null, functionTreeNode);
        if (objectArray != null) {
            return objectArray.length;
        }
        return 0;
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        List<FunctionTreeNodeWithId> list = this.getOptionNodes(functionTreeNode);
        this.options = list.toArray(new FunctionTreeNodeWithId[0]);
        return this.options;
    }

    protected List<FunctionTreeNodeWithId> getOptionNodes(FunctionTreeNode functionTreeNode) {
        return this.getSiblingNodes(functionTreeNode);
    }

    private List<FunctionTreeNodeWithId> getSiblingNodes(FunctionTreeNode functionTreeNode) {
        ArrayList<FunctionTreeNodeWithId> arrayList = new ArrayList<FunctionTreeNodeWithId>();
        FunctionTreeNode functionTreeNode2 = SegmentationNode.getParentNodeOrDefaultPort(functionTreeNode);
        if (functionTreeNode2 != null) {
            this.addDescriptorNodes(arrayList, functionTreeNode2, functionTreeNode);
        }
        return arrayList;
    }

    protected void addDescriptorNodes(List<DescriptorTreeNode> list, FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        for (FunctionTreeNode functionTreeNode3 : functionTreeNode.getChildList()) {
            if (!(functionTreeNode3 instanceof DescriptorTreeNode)) continue;
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNode3;
            if (functionTreeNode3 == functionTreeNode2 || !this.shouldAdd(functionTreeNode3)) continue;
            list.add(descriptorTreeNode);
        }
    }

    protected boolean shouldAdd(FunctionTreeNode functionTreeNode) {
        return true;
    }

    public static class SegmentationIdParameter
    extends IDParameter {
        public SegmentationIdParameter(String string, String string2, String string3, boolean bl) {
            super(string, string2, string3);
        }

        @Override
        protected List<FunctionTreeNodeWithId> getOptionNodes(FunctionTreeNode functionTreeNode) {
            ArrayList<FunctionTreeNodeWithId> arrayList = new ArrayList<FunctionTreeNodeWithId>();
            arrayList.add(new SegmentationNode(){

                @Override
                public String getNodeString(FunctionTreeNode.TextType textType) {
                    return this.getDefault();
                }

                @Override
                public String getUid() {
                    return this.getDefault();
                }

                public int hashCode() {
                    return 0;
                }

                public boolean equals(Object object) {
                    if (object instanceof SegmentationNode) {
                        return object.hashCode() == 0;
                    }
                    return false;
                }
            });
            FunctionTreeNode functionTreeNode2 = SegmentationNode.getParentNode(functionTreeNode);
            if (functionTreeNode2 != null) {
                arrayList.addAll(SegmentationNode.getSegmentations(functionTreeNode2));
            }
            return arrayList;
        }

        protected String getDefault() {
            return "All";
        }
    }

    public static class LinkedIDParameter
    extends IDParameter {
        public LinkedIDParameter(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        @Override
        public boolean isVisible(FunctionTreeNode functionTreeNode) {
            int n = SegmentationNode.getNodesAtLevel(functionTreeNode.getRoot(), SegmentationNode.getSegmentationLevel(functionTreeNode)).size();
            return n == 0 || n > 1;
        }

        @Override
        protected List<FunctionTreeNodeWithId> getOptionNodes(FunctionTreeNode functionTreeNode) {
            SegmentationNode segmentationNode;
            ArrayList<FunctionTreeNodeWithId> arrayList = new ArrayList<FunctionTreeNodeWithId>();
            arrayList.add(new SegmentationNode(this){

                @Override
                public String getNodeString(FunctionTreeNode.TextType textType) {
                    return "None";
                }

                @Override
                public String getUid() {
                    return "None";
                }

                public int hashCode() {
                    return 0;
                }

                public boolean equals(Object object) {
                    if (object instanceof SegmentationNode) {
                        return object.hashCode() == 0;
                    }
                    return false;
                }

                @Override
                public String toString() {
                    return "None";
                }
            });
            SegmentationNodeList segmentationNodeList = SegmentationNode.getNodesAtLevel(functionTreeNode.getRoot(), SegmentationNode.getSegmentationLevel(functionTreeNode));
            if (segmentationNodeList.size() > 0 && (segmentationNode = (SegmentationNode)segmentationNodeList.get(0)) != functionTreeNode) {
                arrayList.add(segmentationNode);
            }
            return arrayList;
        }

        @Override
        public String format(Workflow workflow, FunctionTreeNode functionTreeNode) {
            String string = this.getAliasOrName();
            if (functionTreeNode != null) {
                String string2 = this.getValueStr();
                FunctionTreeNodeWithId functionTreeNodeWithId = functionTreeNode.getNodeById(string2);
                if (functionTreeNodeWithId != null) {
                    return string + " = " + functionTreeNodeWithId.getAliasOrNodeString();
                }
                return string + " = " + string2;
            }
            return string;
        }

        public static class AppliesToLinkIDParameter
        extends IDParameter {
            public AppliesToLinkIDParameter(String string, String string2, String string3) {
                super(string, string2, string3);
            }

            @Override
            public boolean isVisible(FunctionTreeNode functionTreeNode) {
                int n = this.getNumberOfOptions(functionTreeNode);
                return n == 0 || n > 1;
            }

            @Override
            protected List<FunctionTreeNodeWithId> getOptionNodes(FunctionTreeNode functionTreeNode) {
                List<SegmentationNode> list;
                ArrayList<FunctionTreeNodeWithId> arrayList = new ArrayList<FunctionTreeNodeWithId>();
                arrayList.add(new SegmentationNode(this){

                    @Override
                    public String getNodeString(FunctionTreeNode.TextType textType) {
                        return "All";
                    }

                    @Override
                    public String getUid() {
                        return "All";
                    }

                    public int hashCode() {
                        return 0;
                    }

                    public boolean equals(Object object) {
                        if (object instanceof SegmentationNode) {
                            return object.hashCode() == 0;
                        }
                        return false;
                    }

                    @Override
                    public String toString() {
                        return "All";
                    }
                });
                FunctionTreeNode functionTreeNode2 = SegmentationNode.getParentNode(functionTreeNode).getParent();
                if (functionTreeNode2 != null && !(list = SegmentationNode.getSegmentations(functionTreeNode2)).isEmpty()) {
                    arrayList.addAll(list);
                }
                return arrayList;
            }
        }
    }

    public static class ChildIDParameter
    extends IDParameter {
        public ChildIDParameter() {
        }

        public ChildIDParameter(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        @Override
        protected List<FunctionTreeNodeWithId> getOptionNodes(FunctionTreeNode functionTreeNode) {
            ArrayList<FunctionTreeNodeWithId> arrayList = new ArrayList<FunctionTreeNodeWithId>();
            FunctionTreeNode functionTreeNode2 = SegmentationNode.getParentNode(functionTreeNode);
            if (functionTreeNode2 != null) {
                List<SegmentationNode> list = SegmentationNode.getSegmentations(functionTreeNode2);
                for (SegmentationNode segmentationNode : list) {
                    this.addDescriptorNodes(arrayList, segmentationNode.getDefaultPort(), functionTreeNode);
                }
            }
            return arrayList;
        }
    }

    public static class IDQuantificationParameter
    extends IDAnalyseParameter {
        public IDQuantificationParameter(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        @Override
        protected boolean shouldAdd(FunctionTreeNode functionTreeNode) {
            return functionTreeNode.getFactor() instanceof PropertyFactor;
        }

        @Override
        public PropertyFactor getFactor(FunctionTreeNode functionTreeNode) {
            return (PropertyFactor)super.getFactor(functionTreeNode);
        }

        @Override
        public PropertyFactor getFactor() {
            return (PropertyFactor)super.getFactor();
        }

        public PropertyFactorParameter.NodePropertyAnalyse getPropertyAnalyse(DescriptorTreeNode descriptorTreeNode) {
            return new PropertyFactorParameter.NodePropertyAnalyse(descriptorTreeNode, this.getAnalyse(descriptorTreeNode), this.getFactor(descriptorTreeNode));
        }
    }

    public static class IDClassifcationParameter
    extends IDAnalyseParameter {
        public IDClassifcationParameter(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        @Override
        protected boolean shouldAdd(FunctionTreeNode functionTreeNode) {
            return functionTreeNode.getFactor() instanceof CategoryFactor;
        }

        @Override
        public CategoryFactor getFactor(FunctionTreeNode functionTreeNode) {
            return (CategoryFactor)super.getFactor(functionTreeNode);
        }

        @Override
        public CategoryFactor getFactor() {
            return (CategoryFactor)super.getFactor();
        }
    }

    public static class IDAnalyseParameter
    extends IDParameter
    implements AnalyseFactorParameter.AnalyseInterface {
        public IDAnalyseParameter(String string, String string2, String string3) {
            super(string, string2, string3);
        }

        public BasicAnalyse getAnalyse(FunctionTreeNode functionTreeNode) {
            FunctionTreeNodeWithId functionTreeNodeWithId = this.getNode(functionTreeNode);
            if (functionTreeNodeWithId != null) {
                return functionTreeNodeWithId.getAnalyse();
            }
            return this.getAnalyse();
        }

        @Override
        public BasicAnalyse getAnalyse() {
            FunctionTreeNodeWithId functionTreeNodeWithId;
            AbstractBreezeFunction abstractBreezeFunction;
            Object object = this.getValueObj();
            if (object instanceof FunctionTreeNodeWithId && (abstractBreezeFunction = (functionTreeNodeWithId = (FunctionTreeNodeWithId)object).getFunction()) != null) {
                return abstractBreezeFunction.getAnalyse();
            }
            return null;
        }

        public Factor getFactor(FunctionTreeNode functionTreeNode) {
            FunctionTreeNodeWithId functionTreeNodeWithId = this.getNode(functionTreeNode);
            if (functionTreeNodeWithId != null) {
                return functionTreeNodeWithId.getFactor();
            }
            return this.getFactor();
        }

        public Factor getFactor() {
            FunctionTreeNodeWithId functionTreeNodeWithId;
            AbstractBreezeFunction abstractBreezeFunction;
            Object object = this.getValueObj();
            if (object instanceof FunctionTreeNodeWithId && (abstractBreezeFunction = (functionTreeNodeWithId = (FunctionTreeNodeWithId)object).getFunction()) != null) {
                return abstractBreezeFunction.getFactor(functionTreeNodeWithId.getIndex());
            }
            return null;
        }
    }
}

