/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AbstractParameter;
import se.prediktera.breeze.common.util.MinMax;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class NumberParameter
extends AbstractParameter {
    private Number value = null;
    private final MinMax minMax;
    private int priority;

    public NumberParameter(String string, String string2, double d, String string3) {
        this(string, string2, d, string3, new MinMax(0.0f, 2.1474836E9f));
    }

    public NumberParameter(String string, String string2, double d, String string3, MinMax minMax) {
        super(string, string2, string3, "");
        this.value = d;
        this.minMax = minMax;
    }

    public void clearValue() {
        this.value = null;
    }

    @Override
    public String getNodeString() {
        return RtDataFormat.toString(this.value.doubleValue());
    }

    public double getValue() {
        return this.value.doubleValue();
    }

    @Override
    public Object getValueObj() {
        return this.value;
    }

    public float getValueFloat() {
        return this.value.floatValue();
    }

    public int getValueInt() {
        return this.value.intValue();
    }

    @Override
    public String getValueStr() {
        if (this.hasValue()) {
            if (this.value instanceof Double) {
                return RtDataFormat.toString(this.value.doubleValue(), 20);
            }
            return RtDataFormat.toString(this.value.doubleValue(), 6);
        }
        return "";
    }

    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public void parse(Node node) {
        String string = node.getTextContent();
        if (string != null) {
            this.value = RtDataFormat.toNumber(string);
        }
    }

    @Override
    public Element save(Element element) {
        Element element2 = XmlParserHelper.addElement(element, "param");
        XmlParserHelper.setAttribute((Node)element2, "name", this.getName());
        if (this.value != null) {
            Number number = this.value;
            if (number instanceof Float) {
                Float f = (Float)number;
                XmlParserHelper.setValue((Node)element2, f.floatValue());
            } else {
                XmlParserHelper.setValue((Node)element2, this.value.doubleValue());
            }
        }
        return element2;
    }

    public void setValue(float f) {
        this.value = Float.valueOf(f);
    }

    public void setValue(double d) {
        this.value = d;
    }

    @Override
    public void setValueStr(String string) {
        this.value = RtDataFormat.isNumber(string) ? Double.valueOf(RtDataFormat.toNumber(string)) : Double.valueOf(0.0);
    }

    public MinMax getMinMax() {
        return this.minMax;
    }

    @Override
    public boolean updateParameterRecursive() {
        return true;
    }

    @Override
    public boolean updateParameterRecursive(FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        return true;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int n) {
        this.priority = n;
    }

    public static class WorkflowUnitParameter
    extends NumberParameter {
        public WorkflowUnitParameter(String string, String string2, double d, String string3) {
            super(string, string2, d, string3);
        }
    }
}

