/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.entry.workflow.Workflow;
import se.prediktera.map.common.error.ErrorHandler;

public abstract class OptionParameter<T extends Option>
extends TextParameter {
    private final List<T> list = new ArrayList<T>();

    public OptionParameter(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    protected void add(T t) {
        ((Option)t).setIndex(this.list.size());
        this.list.add(t);
    }

    protected void remove(T t) {
        if (this.getIndex() == this.list.indexOf(t)) {
            throw new ErrorHandler.WarningMessageException("You cannot remove the currently selected option");
        }
        this.list.remove(t);
    }

    @Override
    public boolean setValue(Object object) {
        return super.setValue(((Option)object).getName());
    }

    public T getValueObj() {
        return (T)((Option)this.list.get(this.getIndex()));
    }

    public void setIndex(int n) {
        this.setValueStr(((Option)this.list.get(n)).getName());
    }

    public int getIndex() {
        String string = this.getValueStr();
        for (int i = 0; i < this.list.size(); ++i) {
            if (!((Option)this.list.get(i)).getName().equals(string)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        return this.list.toArray();
    }

    public boolean contains(T t) {
        return this.list.contains(t);
    }

    public String getDisplayString() {
        return StringHelper.formatLabel(this.toString());
    }

    public static class Option {
        private final String name;
        private String description;
        private int index;

        public Option(String string, String string2) {
            this.name = string;
            this.description = string2;
        }

        public String toString() {
            return this.description;
        }

        public String getDisplayName() {
            return StringHelper.formatLabel(this.description);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Option) {
                Option option = (Option)object;
                return option.name.equals(this.name);
            }
            return super.equals(object);
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public void setDescription(String string) {
            this.description = string;
        }

        @Generated
        public void setIndex(int n) {
            this.index = n;
        }

        public static class OptionNoFormat
        extends Option {
            public OptionNoFormat(String string, String string2) {
                super(string, string2);
            }

            @Override
            public String getDisplayName() {
                return this.getDescription();
            }
        }
    }
}

