/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.BasicAnalyse;
import se.prediktera.breeze.common.entry.factor.Factor;
import se.prediktera.breeze.common.entry.factor.property.PropertyFactor;
import se.prediktera.breeze.common.entry.factor.property.PropertyList;
import se.prediktera.breeze.common.entry.tree.analysistree.DescriptorTreeNode;
import se.prediktera.breeze.common.entry.tree.analysistree.SegmentationNode;
import se.prediktera.breeze.common.entry.tree.functiontree.AdditionalFactor;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.TextParameter;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class PropertyFactorParameter
extends TextParameter {
    private NodePropertyAnalyse[] options;
    private String nodeUid;
    private String analyseUid;
    private int optionIndex;

    public PropertyFactorParameter(String string, String string2, int n) {
        super(string, string2, "id", null);
        this.optionIndex = n;
    }

    @Override
    public boolean setValue(Object object) {
        if (object instanceof NodePropertyAnalyse) {
            NodePropertyAnalyse nodePropertyAnalyse = (NodePropertyAnalyse)object;
            super.setValue(nodePropertyAnalyse.factor().getUid());
            this.nodeUid = nodePropertyAnalyse.node().getUid();
            this.analyseUid = nodePropertyAnalyse.analyse().getUid();
            return true;
        }
        return false;
    }

    @Override
    public void parse(Node node) {
        super.parse(node);
        this.nodeUid = XmlParserHelper.getAttribute(node, "node");
        this.analyseUid = XmlParserHelper.getAttribute(node, "analyse");
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        if (this.nodeUid != null) {
            XmlParserHelper.setAttribute((Node)element2, "node", this.nodeUid);
        }
        if (this.analyseUid != null) {
            XmlParserHelper.setAttribute((Node)element2, "analyse", this.analyseUid);
        }
        return element2;
    }

    @Override
    public int getValueHashCode() {
        int n = super.getValueHashCode();
        if (this.nodeUid != null) {
            n += StringHelper.hashCode(this.nodeUid);
        }
        if (this.analyseUid != null) {
            n += StringHelper.hashCode(this.analyseUid);
        }
        return n;
    }

    public boolean replaceAnalyse(BasicAnalyse basicAnalyse, BasicAnalyse basicAnalyse2) {
        String string = this.getValueStr();
        PropertyList propertyList = basicAnalyse.getPropertyFactors();
        PropertyList propertyList2 = basicAnalyse2.getPropertyFactors();
        boolean bl = false;
        for (int i = 0; i < propertyList.size(); ++i) {
            if (!string.equals(propertyList.get(i).getUid())) continue;
            if (i >= propertyList2.size()) break;
            this.setValueStr(propertyList2.get(i).getUid());
            bl = true;
            break;
        }
        if (basicAnalyse.getUid().equals(this.analyseUid)) {
            this.analyseUid = basicAnalyse2.getUid();
        }
        return bl;
    }

    @Override
    public Object getValueObj() {
        NodePropertyAnalyse nodePropertyAnalyse;
        if (this.options != null && (nodePropertyAnalyse = this.getNodePropertyAnalyse(this.options)) != null) {
            return nodePropertyAnalyse;
        }
        return super.getValueObj();
    }

    private NodePropertyAnalyse getNodePropertyAnalyse(NodePropertyAnalyse[] nodePropertyAnalyseArray) {
        String string = this.getValueStr();
        for (NodePropertyAnalyse nodePropertyAnalyse : nodePropertyAnalyseArray) {
            if (this.nodeUid != null && !nodePropertyAnalyse.node().getUid().equals(this.nodeUid) || !nodePropertyAnalyse.factor().getUid().equals(string)) continue;
            return nodePropertyAnalyse;
        }
        return null;
    }

    public NodePropertyAnalyse getNodePropertyAnalyse(FunctionTreeNode functionTreeNode) {
        return this.getNodePropertyAnalyse(this.getOptions(null, functionTreeNode));
    }

    public NodePropertyAnalyse[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        ArrayList<NodePropertyAnalyse> arrayList = new ArrayList<NodePropertyAnalyse>();
        FunctionTreeNode functionTreeNode2 = SegmentationNode.getParentNodeOrDefaultPort(functionTreeNode);
        if (functionTreeNode2 != null) {
            this.addDescriptorNodes(arrayList, functionTreeNode2, functionTreeNode);
        }
        this.options = arrayList.toArray(new NodePropertyAnalyse[0]);
        return this.options;
    }

    protected void addDescriptorNodes(List<NodePropertyAnalyse> list, FunctionTreeNode functionTreeNode, FunctionTreeNode functionTreeNode2) {
        for (FunctionTreeNode functionTreeNode3 : functionTreeNode.getChildList()) {
            Object object;
            Object object2;
            if (!(functionTreeNode3 instanceof DescriptorTreeNode)) continue;
            DescriptorTreeNode descriptorTreeNode = (DescriptorTreeNode)functionTreeNode3;
            if (PropertyFactorParameter.support(list, functionTreeNode2, descriptorTreeNode) && (object2 = descriptorTreeNode.getFactor()) instanceof PropertyFactor) {
                object = (PropertyFactor)object2;
                list.add(new NodePropertyAnalyse(descriptorTreeNode, descriptorTreeNode.getAnalyse(), (PropertyFactor)object));
            }
            if ((object = descriptorTreeNode.getAdditionalFactors()) != null) {
                object2 = object.iterator();
                while (object2.hasNext()) {
                    AdditionalFactor additionalFactor = (AdditionalFactor)object2.next();
                    Factor factor = additionalFactor.getFactor();
                    if (!(factor instanceof PropertyFactor)) continue;
                    PropertyFactor propertyFactor = (PropertyFactor)factor;
                    list.add(new NodePropertyAnalyse(descriptorTreeNode, descriptorTreeNode.getAnalyse(), propertyFactor));
                }
            }
            this.addDescriptorNodes(list, descriptorTreeNode, functionTreeNode2);
        }
    }

    @Override
    public int getOptionIndex() {
        return this.optionIndex;
    }

    private static boolean support(List<NodePropertyAnalyse> list, FunctionTreeNode functionTreeNode, DescriptorTreeNode descriptorTreeNode) {
        if (descriptorTreeNode == functionTreeNode) {
            return false;
        }
        for (FunctionParameter object : descriptorTreeNode.getFunction().getParameterList()) {
            if (!(object instanceof PropertyFactorParameter)) continue;
            return false;
        }
        for (NodePropertyAnalyse nodePropertyAnalyse : list) {
            if (!nodePropertyAnalyse.analyse().equals(descriptorTreeNode.getAnalyse()) || !nodePropertyAnalyse.factor().equals(descriptorTreeNode.getFactor())) continue;
            return false;
        }
        return true;
    }

    public record NodePropertyAnalyse(DescriptorTreeNode node, BasicAnalyse analyse, PropertyFactor factor) {
        @Override
        public String toString() {
            String string;
            String string2 = this.getAliasOrNodeString();
            if (string2.equals(string = this.factor.getName()) || "Expression".equals(string)) {
                return string2;
            }
            return string2 + " - " + string;
        }

        private String getAliasOrNodeString() {
            DescriptorTreeNode descriptorTreeNode;
            FunctionTreeNode functionTreeNode;
            if (!this.node.isVisible() && (functionTreeNode = this.node.getParent()) instanceof DescriptorTreeNode && (descriptorTreeNode = (DescriptorTreeNode)functionTreeNode).getClass().equals(this.node.getClass())) {
                return descriptorTreeNode.getAliasOrNodeString();
            }
            return this.node.getAliasOrNodeString();
        }

        public int getFactorIndex() {
            int n = this.analyse.getCategoryFactors().size();
            return n + this.analyse.getPropertyFactors().indexOf(this.factor);
        }
    }
}

