/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.analyse.RtAnalyse;
import se.prediktera.breeze.common.realtime.RtModelParameters;
import se.prediktera.breeze.common.realtime.descriptor.AbstractDescriptor;
import se.prediktera.breeze.common.realtime.descriptor.parameter.AddParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.BooleanParameter;
import se.prediktera.breeze.common.realtime.descriptor.parameter.FunctionParameter;
import se.prediktera.breeze.common.util.StringHelper;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;

public class RuleImageParameter
extends BooleanParameter {
    private final RuleImageFunction function;
    private String settings;

    public RuleImageParameter(RuleImageFunction ruleImageFunction, String string, String string2, boolean bl) {
        super("rule", string, string2, bl);
        this.function = ruleImageFunction;
    }

    @Override
    public void copy(FunctionParameter functionParameter) {
        super.copy(functionParameter);
        this.settings = ((RuleImageParameter)functionParameter).settings;
    }

    @Override
    public int getValueHashCode() {
        int n = StringHelper.hashCode(this.getValueStr());
        return n += StringHelper.hashCode(this.settings);
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        if (this.settings != null) {
            XmlParserHelper.setAttribute((Node)element2, "settings", this.settings);
        }
        return element2;
    }

    @Override
    public void parse(Node node) {
        super.parse(node);
        this.settings = XmlParserHelper.getAttribute(node, "settings");
    }

    public void setSettings(List<AddParameter.AddClass> list) {
        JSONArray jSONArray = new JSONArray();
        for (AddParameter.AddClass addClass : list) {
            jSONArray.put((Object)new RuleImageRecord(addClass.toString(), addClass.isIncluded()).toJSON());
        }
        this.settings = jSONArray.toString().replaceAll("\"", "'");
    }

    public RuleImageFunction getFunction() {
        return this.function;
    }

    public List<? extends AddParameter.AddBasic> getRuleImages() {
        ArrayList<AddRule> arrayList = new ArrayList<AddRule>();
        Object object = ((AbstractDescriptor)((Object)this.function)).getAnalyse();
        if (object instanceof RtAnalyse) {
            RtAnalyse rtAnalyse = (RtAnalyse)object;
            object = this.getRuleImageRecords();
            RtModelParameters.RtModel rtModel = rtAnalyse.getRtModel();
            RtModelParameters.RtModuleSetup rtModuleSetup = rtModel.getModule("Base");
            int n = rtModuleSetup.getScalarInt("endMembers");
            for (int i = 1; i <= n; ++i) {
                RtModelParameters.RtModuleSetup rtModuleSetup2 = rtModel.getModule("endMember" + i);
                String string = rtModuleSetup2.getString("name");
                arrayList.add(new AddRule(string, RuleImageRecord.isIncluded((List<RuleImageRecord>)object, string)));
            }
        }
        return arrayList;
    }

    public List<RuleImageRecord> getRuleImageRecords() {
        return RuleImageRecord.parse(this.settings);
    }

    public static interface RuleImageFunction {
    }

    public record RuleImageRecord(String name, boolean included) {
        public JSONObject toJSON() {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("n", (Object)this.name);
            jSONObject.put("i", this.included);
            return jSONObject;
        }

        public static List<RuleImageRecord> parse(String string) {
            ArrayList<RuleImageRecord> arrayList;
            block4: {
                arrayList = new ArrayList<RuleImageRecord>();
                if (string == null) break block4;
                if (string.startsWith("[")) {
                    JSONArray jSONArray = new JSONArray(string.replaceAll("'", "\""));
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        arrayList.add(RuleImageRecord.fromJSON(jSONArray.getJSONObject(i)));
                    }
                } else {
                    String[] stringArray = string.split(";");
                    for (int i = 0; i < stringArray.length; ++i) {
                        String[] stringArray2 = stringArray[i].split(",");
                        arrayList.add(new RuleImageRecord(stringArray2[0], stringArray2.length != 2));
                    }
                }
            }
            return arrayList;
        }

        public static RuleImageRecord fromJSON(JSONObject jSONObject) {
            String string = jSONObject.optString("n", "");
            boolean bl = jSONObject.optBoolean("i", true);
            return new RuleImageRecord(string, bl);
        }

        public static boolean isIncluded(List<RuleImageRecord> list, String string) {
            RuleImageRecord ruleImageRecord = RuleImageRecord.getByName(list, string);
            return ruleImageRecord == null || ruleImageRecord.included;
        }

        private static RuleImageRecord getByName(List<RuleImageRecord> list, String string) {
            for (RuleImageRecord ruleImageRecord : list) {
                if (!ruleImageRecord.name.equalsIgnoreCase(string)) continue;
                return ruleImageRecord;
            }
            return null;
        }
    }

    public static class AddRule
    extends AddParameter.AddBasic {
        private final String name;

        public AddRule(String string, boolean bl) {
            this.name = string;
            this.included = bl;
        }

        @Override
        public Object getObject() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

