/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class SegmentationParameter
extends NumberParameter {
    private SeparateOption option = SeparateOption.NORMAL;

    public SegmentationParameter(String string) {
        super(string, "Separate / Merge", 0.0, null, null);
    }

    @Override
    public String getNodeString() {
        if (this.hasValue()) {
            return this.option.getName() + " " + RtDataFormat.toString(this.getValue());
        }
        return this.option.getName();
    }

    public SeparateOption getOp() {
        return this.option;
    }

    @Override
    public void parse(Node node) {
        String string = XmlParserHelper.getAttribute(node, "type");
        this.option = SeparateOption.valueOf(string.toUpperCase());
    }

    @Override
    public void setValueStr(String string) {
        this.option = SeparateOption.valueOf(string.toUpperCase());
    }

    @Override
    public boolean setValue(Object object) {
        this.option = (SeparateOption)((Object)object);
        return true;
    }

    @Override
    public Object getValueObj() {
        return this.option;
    }

    @Override
    public Element save(Element element) {
        this.clearValue();
        Element element2 = super.save(element);
        XmlParserHelper.setAttribute((Node)element2, "type", this.option.xmlName());
        return element2;
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        return SeparateOption.values();
    }

    public static enum SeparateOption {
        NORMAL("Normal"),
        SEPARATE("Separate adjacent objects"),
        MERGEALL("Merge all object into one"),
        MERGEROW("Merge all object per row"),
        MERGECOLUMN("Merge all object per column");

        private final String name;

        private SeparateOption(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public String xmlName() {
            return this.name();
        }

        public String toString() {
            return this.name;
        }
    }
}

