/*
 * Decompiled with CFR 0.152.
 */
package se.prediktera.breeze.common.realtime.descriptor.parameter;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import se.prediktera.breeze.common.entry.tree.functiontree.FunctionTreeNode;
import se.prediktera.breeze.common.realtime.descriptor.parameter.NumberParameter;
import se.prediktera.breeze.common.util.RtDataFormat;
import se.prediktera.breeze.common.util.xmlproperties.XmlParserHelper;
import se.prediktera.breeze.entry.workflow.Workflow;

public class SummaryParameter
extends NumberParameter {
    private Summary op = Summary.SUM;

    public SummaryParameter() {
        super("summary", null, 0.0, null, null);
    }

    @Override
    public String getNodeString() {
        if (this.hasValue()) {
            return this.op.getName() + " " + RtDataFormat.toString(this.getValue());
        }
        return this.op.getName();
    }

    public Summary getOp() {
        return this.op;
    }

    @Override
    public void parse(Node node) {
        String string = XmlParserHelper.getAttribute(node, "type");
        this.op = Summary.valueOf(string.toUpperCase());
    }

    @Override
    public void setValueStr(String string) {
        this.op = Summary.valueOf(string.toUpperCase());
        this.clearValue();
    }

    @Override
    public String getValueStr() {
        return this.op.getName();
    }

    public void setValue(Summary summary) {
        this.op = summary;
    }

    @Override
    public boolean setValue(Object object) {
        this.op = (Summary)((Object)object);
        return true;
    }

    @Override
    public Object getValueObj() {
        return this.op;
    }

    @Override
    public Element save(Element element) {
        Element element2 = super.save(element);
        XmlParserHelper.setAttribute((Node)element2, "type", this.op.name());
        return element2;
    }

    @Override
    public String toString() {
        if (this.hasValue()) {
            return this.op.toString() + ", value=" + RtDataFormat.toString(this.getValue());
        }
        return this.op.toString();
    }

    @Override
    public Object[] getOptions(Workflow workflow, FunctionTreeNode functionTreeNode) {
        return Summary.values();
    }

    public static enum Summary {
        SUM("Sum"),
        AVERAGE("Avg"),
        MIN("Min"),
        MAX("Max");

        private final String shortName;

        private Summary(String string2) {
            this.shortName = string2;
        }

        public String getName() {
            return this.toString();
        }

        public String getShortName() {
            return this.shortName;
        }

        public float perform(float f, float f2) {
            switch (this.ordinal()) {
                case 0: 
                case 1: {
                    return f + f2;
                }
                case 3: {
                    return Math.max(f, f2);
                }
                case 2: {
                    return Math.min(f, f2);
                }
            }
            return 0.0f;
        }
    }
}

